C*****  CFFT    Complex FFT (in-place)            MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CFFT (C,N,IFLG)
C
C       where,
C
C       C       Complex input/output vector.
C
C       N       Integer input element count.
C
C       IFLG    Integer input processing option flag:
C                   = 1 for forward FFT
C                   =-1 for inverse FFT
C
C
C  DESCRIPTION
C
C       This routine performs either a forward or
C       inverse complex FFT on the data stored
C       in vector C, depending on the value of IFLG.
C
C       If IFLG=1, the routine performs a forward FFT.
C       The results are overlaid on vector C.
C       These results are not properly scaled and may be
C       scaled using CFFTSC to multiply by 1/N.
C
C       If IFLG=-1, the routine performs an inverse FFT.  The
C       results are overlaid on vector C and do
C       not need to be scaled.
C
C       N must be a power of two.
C
C       Refer to Appendix B for machine dependent notes.
C
C
C  REFERENCE
C
C       This code was taken from 'Programs for Digital Signal
C       Processing', by the IEEE Acoustics, Speech, and Signal
C       Processing Society.  The only significant change was to
C       reorder the input data from having separate arrays for the
C       real and imaginary parts to having one input array
C       containing both the real and imaginary parts.
C
C       J. W. Cooley and J. W. Tukey.  1965.  An algorithm for
C       the machine calculation of complex Fourier Series.
C       Math. Comp., Vol. 19,  pp. 297-301.
C
C       G. D. Bergland.  1969.  A radix-eight fast Fourier
C       transform subroutine for real-valued series.  IEEE
C       Trans. on Audio and Electroacoust., Vol. AU-17,  pp.
C       138-144.
C
C       E. O. Brigham.  1974.  The fast Fourier transform.
C       Englewood Cliffs NJ: Prentice-Hall.
C
C  EXAMPLE
C
C       CALL CFFT (C,8,1)
C
C       Input Operands:
C
C       C = (1.0,0.0)
C           (1.0,0.0)
C           (1.0,0.0)
C           (1.0,0.0)
C           (1.0,0.0)
C           (1.0,0.0)
C           (1.0,0.0)
C           (1.0,0.0)
C
C       Output Operands:
C
C       C = (8.0,0.0)
C           (0.0,0.0)
C           (0.0,0.0)
C           (0.0,0.0)
C           (0.0,0.0)
C           (0.0,0.0)
C           (0.0,0.0)
C           (0.0,0.0)
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
C
      SUBROUTINE CFFT(C,N,IFLG)
C
      INTEGER IFLG,N,DI
      REAL C(1)
      IF (N.LE.1 .OR. (IFLG.NE.-1 .AND. IFLG.NE.1)) GOTO 900
      DI = 2
      CALL QTC018(C,N,DI,IFLG)
900   RETURN
      END
