C*****  CFFT2D  Complex to Complex 2-D FFT        MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CFFT2D (C,NRC,NCC,IFLG)
C
C       where,
C
C       C       Complex input/output matrix.
C
C       NRC     Integer input number of rows.
C
C       NCC     Integer input number of columns.
C
C       IFLG    Integer input processing option flag:
C                   = 1 for forward FFT
C                   =-1 for inverse FFT
C
C
C  DESCRIPTION
C
C       This routine performs either a forward or inverse
C       two-dimensional complex FFT on data stored in
C       matrix C, depending on the value of IFLG.
C
C       If IFLG=1, the routine performs a forward two-dimensional
C       FFT.  The results are overlaid on matrix C. These results
C       are not properly scaled and may be scaled using VSMUL to
C       multiply by 1/(NRC*NCC).
C
C       If IFLG=-1, the routine performs an inverse  two-dimensional
C       FFT.  The results are overlaid on matrix C and do not need to
C       be scaled.
C
C       Both NRC and NCC must be powers of two.
C
C       Refer to Appendix B for machine dependent notes.
C
C
C  REFERENCE
C
C       J. W. Cooley and J. W. Tukey.  1965.  An algorithm for
C       the machine calculation of complex Fourier Series.
C       Math. Comp., Vol. 19,  pp. 297-301.
C
C       G. D. Bergland.  1969.  A radix-eight fast Fourier
C       transform subroutine for real-valued series.  IEEE
C       Trans. on Audio and Electroacoust., Vol. AU-17,  pp.
C       138-144.
C
C       E. O. Brigham.  1974.  The fast Fourier transform.
C       Englewood Cliffs NJ: Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL CFFT2D (C,8,8,1)
C
C       Input Operands:
C
C       C =  (2.0,0.0) (2.0,0.0) ... for 8 columns total  (2.0,0.0)
C            (0.0,0.0) (0.0,0.0) ... for 8 columns total  (0.0,0.0)
C            (0.0,0.0) (0.0,0.0) ... for 8 columns total  (0.0,0.0)
C            (0.0,0.0) (0.0,0.0) ... for 8 columns total  (0.0,0.0)
C            (0.0,0.0) (0.0,0.0) ... for 8 columns total  (0.0,0.0)
C            (0.0,0.0) (0.0,0.0) ... for 8 columns total  (0.0,0.0)
C            (0.0,0.0) (0.0,0.0) ... for 8 columns total  (0.0,0.0)
C            (0.0,0.0) (0.0,0.0) ... for 8 columns total  (0.0,0.0)
C
C       Output Operands:
C
C       C =  (16.0,0.0) (0.0,0.0) ... for 8 columns total  (0.0,0.0)
C            (16.0,0.0) (0.0,0.0) ... for 8 columns total  (0.0,0.0)
C            (16.0,0.0) (0.0,0.0) ... for 8 columns total  (0.0,0.0)
C            (16.0,0.0) (0.0,0.0) ... for 8 columns total  (0.0,0.0)
C            (16.0,0.0) (0.0,0.0) ... for 8 columns total  (0.0,0.0)
C            (16.0,0.0) (0.0,0.0) ... for 8 columns total  (0.0,0.0)
C            (16.0,0.0) (0.0,0.0) ... for 8 columns total  (0.0,0.0)
C            (16.0,0.0) (0.0,0.0) ... for 8 columns total  (0.0,0.0)
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE CFFT2D(C,NRC,NCC,IFLG)
C
      REAL C(1)
      INTEGER NRC,NCC,IFLG,I,IC
      IF (NRC.LE.0 .OR. NCC.LE.0 .OR.
     +  (IFLG.NE.-1 .AND. IFLG.NE.1)) GOTO 900
      IF (NCC.LE.1) GOTO 150
C --- ROWS FIRST
      IC = NRC+NRC
      DO 100 I = 1,NRC+NRC,2
        CALL QTC018(C(I),NCC,IC,IFLG)
100   CONTINUE
C --- NOW COLUMNS
150   IF (NRC.LE.1) GOTO 900
      IC = 2
      DO 200 I = 1,NCC*(NRC+NRC),NRC+NRC
        CALL QTC018(C(I),NRC,IC,IFLG)
200   CONTINUE
900   RETURN
      END
