C*****  CFFTX   Complex FFT with SIN/COS Table  MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1987-1988 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CFFTX (C,IC,N,IDIR,INIT,RTAB,IERR)
C
C       where,
C
C       C       Complex input/output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C       IDIR    Integer input direction flag:
C                  IDIR > 0  - Perform forward FFT.
C                  IDIR = 0  - No FFT performed.
C                  IDIR < 0  - Perform inverse FFT.
C
C       INIT    Integer input initialization flag:
C                  INIT <> 0 - Initialize RTAB table.
C                  INIT =  0 - No initialization.
C
C       RTAB    Real input/output vector of length N+1.
C                  Input when INIT = 0.
C                  Output when INIT <> 0.
C
C       IERR    Integer output completion code:
C                  IERR =  0  - Normal completion.
C                  IERR >  0  - Invalid value of N (see below).
C                  IERR = -1  - Invalid value of IC (IC<2).
C                  IERR = -2  - Invalid tables (see below).
C
C  DESCRIPTION
C
C       This routine performs either a forward or inverse
C       complex FFT on the data stored in vector C, depending
C       on the value of IDIR.
C
C       If IDIR > 0, the routine performs a forward FFT.  The results
C       are overlaid on vector C.  These results are not properly
C       scaled and may be scaled using CFFTSS to multiply by 1/N.
C
C       If IDIR < 0, the routine performs an inverse FFT.  The results
C       are overlaid on vector C and do not need to be scaled.
C
C       If INIT is nonzero, then a table corresponding to the specific
C       value of N is generated, stored and returned in the vector RTAB.
C       If INIT = 0, RTAB is not generated, thus a table previously
C       generated must be supplied as an input in RTAB.  A sine/cosine
C       table generated by this routine may also be used as input
C       to the Math Advantage routine RFFTX.
C
C       When RTAB is generated, the value of N is stored in the
C       first element of the table.  In subsequent calls with INIT = 0,
C       the input value of N is checked against the first element of
C       RTAB.  If N is greater than the first element from RTAB then
C       the table is declared to be invalid.
C
C       If both IDIR and INIT are nonzero, then the table generation
C       occurs prior to performing the FFT.  If INIT is nonzero and
C       IDIR is zero, the table generation occurs but no FFT is performed.
C       If both IDIR and INIT are zero, the only action is the validity
C       checking of N, IC, and the input table RTAB.
C
C       N must be a power of two.  If the value of N is invalid, then
C       the value returned in IERR is the smallest valid length that
C       is greater than N; i.e., IERR is set to the smallest power of
C       two > N.
C
C       Refer to Appendix B for machine dependent notes.
C
C
C  REFERENCE
C
C       J. W. Cooley and J. W. Tukey.  1965.  An algorithm for
C       the machine calculation of complex Fourier Series.
C       Math. Comp., Vol. 19,  pp. 297-301.
C
C       G. D. Bergland.  1969.  A radix-eight fast Fourier
C       transform subroutine for real-valued series.  IEEE
C       Trans. on Audio and Electroacoust., Vol. AU-17,  pp.
C       138-144.
C
C       E. O. Brigham.  1974.  The fast Fourier transform.
C       Englewood Cliffs NJ: Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL CFFTX(C,2,8,1,1,RTAB,IERR)
C
C       Input Operands:
C
C       C = (1.0, 0.0)
C           (1.0, 0.0)
C           (1.0, 0.0)
C           (1.0, 0.0)
C           (1.0, 0.0)
C           (1.0, 0.0)
C           (1.0, 0.0)
C           (1.0, 0.0)
C
C       Output Operands:
C
C       C = (8.0, 0.0)
C           (0.0, 0.0)
C           (0.0, 0.0)
C           (0.0, 0.0)
C           (0.0, 0.0)
C           (0.0, 0.0)
C           (0.0, 0.0)
C           (0.0, 0.0)
C
C       RTAB =  8.000000000
C               0.707106769
C               1.000000000
C               0.707106769
C               0.000000000
C              -0.707106769
C              -1.000000000
C              -0.707106769
C               0.000000000
C
C       IERR = 0
C
C  HISTORY
C         1) Feb 88     B. D. Leback    Original.
C
      SUBROUTINE CFFTX (C, IC, N, IDIR, INIT, RTAB, IERR)
C
      REAL    C(1), RTAB(1)
      INTEGER IC, N, IDIR, INIT, IERR, NFFT, NT
C
C-----------------------------------------------------------------------
C
      IERR =  0
C
C  CHECK THAT N IS A POWER OF 2
C
      NFFT = 1
      DO 10 I = 1, 15
         NFFT = NFFT + NFFT
         IF (NFFT .GT. N) THEN
            IERR = NFFT
            GO TO 800
         ENDIF
         IF (NFFT .EQ. N) GO TO 20
   10 CONTINUE
C
C  CHECK VALIDITY OF STRIDE
C
   20 CONTINUE
      IF (IC .LT. 2) THEN
         IERR = -1
         GO TO 800
      ENDIF
C
C  CHECK VALIDITY OF TABLES
C
      IF (INIT .EQ. 0) THEN
         IF (N .GT. IFIX( RTAB(1) )) THEN
            IERR = -2
            GO TO 800
         ELSE
            NT = IFIX( RTAB(1) )
         ENDIF
      ELSE
         CALL QTC047 (RTAB(2), N)
         RTAB(1) = FLOAT(N)
         NT = N
      ENDIF
C
C  PERFORM FFT
C
      IF (IDIR .EQ. 0) GO TO 800
C
      CALL QTC046 (C(1), N, IC, IDIR, RTAB(2), NT)
C
C  EXIT ROUTINE
C
  800 CONTINUE
      RETURN
      END
