C*****  CMFUSV  Complex Full Solve                MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CMFUSV (A,NRA,N,B,NRB,M,IPERM,X,NRX)
C
C       where,
C
C       A       Complex input matrix.  A contains the LU factored form.
C
C       NRA     Integer input number of rows in full matrix A.
C
C       N       Integer input order of submatrix A.
C
C       B       Complex input matrix containing M right-hand sides.
C
C       NRB     Integer input number of rows in full matrix B.
C
C       M       Integer input number of right-hand sides.
C
C       IPERM   Integer input permutation vector of length N.
C
C       X       Complex output matrix containing solution vectors.
C
C       NRX     Integer input number of rows in full matrix X.
C
C
C  DESCRIPTION
C
C       This routine solves a complex system Ax = b,
C       where A has been factored into LU form by CMFUFC.
C
C
C  REFERENCE
C
C       J. H. Wilkinson.  1965.  The algebraic eigenvalue prob-
C       lem.  New York: Oxford University Press.
C
C       G. W. Stewart.  1973.  Introduction to matrix computa-
C       tions.  New York: Academic Press.
C
C
C  EXAMPLE
C
C       CALL CMFUSV (A,3,3,B,3,2,IPERM,X,3)
C
C       Input Operands:
C
C       A = (0.200,-0.400)  ( 1.000,-1.000)  ( 7.000,4.000)
C           (0.000, 0.000)  ( 0.154,-0.231)  ( 0.923,2.615)
C           (1.000, 1.000)  (-2.000, 0.000)  (-0.250,1.250)
C
C       B = ( -32.000, 36.000)   ( -52.000, 76.000)
C           (-134.000,102.000)   (-220.000,230.000)
C           ( -94.000, 12.000)   (-171.000, 57.000)
C
C       IPERM = 2
C               3
C               1
C
C       Output Operands:
C
C       X = (1.000,3.000)   ( 6.000, 8.000)
C           (2.000,4.000)   ( 9.000,11.000)
C           (5.000,7.000)   (10.000,12.000)
C
C  HISTORY
C         1) Nov 84     D. Cooper       Original.
C                       R. Coleman
C
      SUBROUTINE CMFUSV(A,NRA,N,B,NRB,M,IPERM,X,NRX)
C
      INTEGER NRA,NRB,M,N,I,IPERM(1),NRX,IA,IA2,LA2,LX2,LB2
      REAL    A(1),B(1),X(1)
C
C   *******************************************************************
C
C     DO VALIDITY CHECKS AND INITIALIZATION
C
      IF (N.LE.0 .OR. M.LE.0 .OR. NRA.LT.N .OR. NRB.LT.N .OR. NRX.LT.N)
     +    GOTO 800
C
      LA2 = NRA + NRA
      LX2 = NRX + NRX
      LB2 = NRB + NRB
      IA = 1
      DO 120 I = 1, N
         CALL CVMOV(B(2*IPERM(I)-1), LB2, X(IA), LX2, M)
         IA = IA + 2
  120 CONTINUE
C
C     PERFORM FORWARD ELIMINATION
C
      CALL QTC002(X,LX2, A, X, LX2, M)
      IF (N .EQ. 1) GO TO 800
C
      IA = 3
      IA2 = LA2 + 3
      DO 330 I = 2, N
         CALL CNDOTP(A(IA),LA2,0,X,2,LX2,X(IA),LX2,I-1,M,3)
         CALL QTC002(X(IA),LX2,A(IA2),X(IA),LX2,M)
         IA = IA + 2
         IA2 = IA2 + LA2 + 2
  330 CONTINUE
C
C     PERFORM BACKWARD SUBSTITUTION
C
      IA = N + N + LA2*(N-1) - 3
      IA2 = N + N - 1
      DO 430 I = N-1, 1, -1
         CALL CNDOTP(A(IA),LA2,0,X(IA2),2,LX2,X(IA2-2),LX2,N-I,M,3)
         IA = IA - 2 - LA2
         IA2 = IA2 - 2
  430 CONTINUE
C
  800 CONTINUE
      RETURN
      END
