C*****  CMMUL   Complex Matrix Multiply           MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CMMUL (A,B,C,NRC,NCC,NCA)
C
C       where,
C
C       A       Complex input matrix.
C
C       B       Complex input matrix.
C
C       C       Complex output matrix.
C
C       NRC     Integer input number of rows in matrices C and A.
C
C       NCC     Integer input number of columns in C and B.
C
C       NCA     Integer input number of columns in A and rows in B.
C
C
C  DESCRIPTION
C
C       This routine multiplies the elements of two complex
C       matrices A and B and stores the results in C.
C
C            C = A * B
C
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C       J. H. Matthews.  1982.  Basic complex variables for
C       mathematics and engineering.  New York: Allyn and
C       Bacon.
C
C
C  EXAMPLE
C
C       CALL CMMUL (A,B,C,3,2,2)
C
C       Input Operands:
C
C       A = ( 1.0,2.0)         ( 7.0, 8.0)
C           ( 3.0,4.0)         ( 9.0,10.0)
C           ( 5.0,6.0)         (11.0,12.0)
C
C       B = (1.0,-1.0)         ( 3.0,-3.0)
C           (2.0,-2.0)         ( 4.0,-4.0)
C
C       Output Operands:
C
C       C = (33.0,3.0)         ( 69.0,7.0)
C           (45.0,3.0)         ( 97.0,7.0)
C           (57.0,3.0)         (125.0,7.0)
C
C  HISTORY
C         1) Nov 84     D. Cooper       Original.
C
      SUBROUTINE CMMUL(A,B,C,NRC,NCC,NCA)
C
      INTEGER NRC,NCC,NCA,IFLG
      REAL    A(1),B(1),C(1)
      IF (NRC.LE.0 .OR. NCC.LE.0 .OR. NCA.LE.0) GOTO 800
        IFLG = 0
        CALL CMMULG(A,NRC,B,NCA,C,NRC,NRC,NCC,NCA,IFLG)
800   RETURN
      END
