C*****  CMMULG  General Complex Matrix Multiply   MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CMMULG (A,NRA,B,NRB,C,NRC,NRCC,NCCC,NCAA,IFLG)
C
C       where,
C
C       A       Complex input matrix.
C
C       NRA     Integer input number of rows in full matrix A.
C
C       B       Complex input matrix.
C
C       NRB     Integer input number of rows in full matrix B.
C
C       C       Complex input/output matrix.
C
C       NRC     Integer input number of rows in full matrix C.
C
C       NRCC    Integer input number of rows in submatrix C.
C
C       NCCC    Integer input number of columns in submatrix C.
C
C       NCAA    Integer input number of columns in submatrix A unless
C               A is to be transposed.  In that case, NCAA
C               is the integer input number of rows in submatrix A.
C
C       IFLG    Integer input processing option flag:
C                  Option 1 = 32 to transpose A before multiplying.
C                  Option 2 = 16 to transpose B before multiplying.
C                  Option 3 =  8 to conjugate A before multiplying.
C                  Option 4 =  4 to conjugate B before multiplying.
C                  Option 5 =  2 to add the product of A and B to
C                                   the input values of C.
C                  Option 6 =  1 to negate result.
C               The value of IFLG is additive, that is:
C                  IFLG = Option 1 + Option 2 + Option 3 +
C                         Option 4 + Option 5 + Option 6
C               If IFLG includes options 5 and 6, CMMULG will
C               negate the product of A and B before adding C.
C               For example, if IFLG = 35, (i.e., 32+2+1) CMMULG
C               will transpose A before multiplying, negate the
C               product of A and B, and add the result to C.
C
C
C  DESCRIPTION
C
C       This routine multiplies the elements of two complex
C       matrices, A and B, and stores the results in matrix C.  This
C       routine is identical to CMMULS except for the addition of
C       parameter IFLG which gives the routine greater flexibility.
C
C       If IFLG = 0, C = A * B
C
C       The input matrices A and B are not altered.
C
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C       J. H. Matthews.  1982.  Basic complex variables for
C       mathematics and engineering.  New York: Allyn and
C       Bacon.
C
C
C  EXAMPLE
C
C       CALL CMMULG (A,3,B,3,C,2,2,2,2,0)
C
C       Input Operands:
C
C       A = ( 1.0,2.0)         ( 7.0, 8.0)
C           ( 3.0,4.0)         ( 9.0,10.0)
C           ( 5.0,6.0)         (11.0,12.0)
C
C       B = (1.0,-1.0)         ( 4.0,-4.0)
C           (2.0,-2.0)         ( 5.0,-5.0)
C           (3.0,-3.0)         ( 6.0,-6.0)
C
C       Output Operands:
C
C       C = (33.0,3.0)         ( 87.0,9.0)
C           (45.0,3.0)         (123.0,9.0)
C
C  HISTORY
C         1) May 85     D. Cooper       Original.
C
      SUBROUTINE CMMULG(A,NRA,B,NRB,C,NRC,NRCC,NCCC,NCAA,IFLG)
C
      INTEGER NRA,NRB,NRC,NRCC,NCCC,NCAA,IFLG,I,JB,JC,TRAA,TRAB
      INTEGER LA2,LB2,LC2,JSW
      REAL    A(1),B(1),C(1)
      IF (NRCC.LE.0 .OR. NCCC.LE.0 .OR. NCAA.LE.0 .OR.
     +    NRA.LE.0 .OR. NRB.LE.0 .OR. NRC.LT.NRCC .OR.
     +    IFLG.LT.0 .OR. IFLG.GE.64) GOTO 800
C
C     THE INPUT SWITCH IFLG IS USED AS FOLLOWS:
C     BIT 0 SETS NEGATE, BIT 1 SETS ACCUMULATE (PASSED TO CNDOTP)
C     BIT 2 SETS CONJUGATE-B, BIT 3 SETS CONJUGATE-A (TO CNDOTP)
C     BIT 4 SETS TRANSPOSE B BEFORE MULTIPLY,
C     BIT 5 SETS TRANSPOSE A BEFORE MULTIPLY.
C
      TRAA = 0
      TRAB = 0
      JSW = IFLG
C      IF (JSW.GE.64) JSW = MOD(JSW,64)
      IF (JSW.LT.32) GOTO 10
        JSW = JSW - 32
        TRAA = 1
10    CONTINUE
      IF (JSW.LT.16) GOTO 20
        JSW = JSW - 16
        TRAB = 1
20    CONTINUE
C
      LA2 = NRA + NRA
      LB2 = NRB + NRB
      LC2 = NRC + NRC
      JB = 1
      JC = 1
      IF (TRAA .EQ. 1 .OR. TRAB .EQ. 1) GOTO 400
C
C     STANDARD CASE:
C     ROWS OF A DOTTED WITH COLUMNS OF B:
      IF(NRA.LT.NRCC .OR. NRB.LT.NCAA) GOTO 800
      DO 200 I = 1, NCCC
        CALL CNDOTP(A,LA2,2,B(JB),2,0,C(JC),2,NCAA,NRCC,JSW)
        JB  = JB + LB2
        JC  = JC + LC2
200   CONTINUE
      GOTO 800
C
C
400   CONTINUE
C     TRANSPOSE AT LEAST ONE MATRIX BEFORE MULTIPLYING:
      IF (TRAA .EQ. 1 .AND. TRAB .EQ. 1) GOTO 700
      IF (TRAB .EQ. 1) GOTO 600
C
C     TRANSPOSE A ONLY:
C     COLUMNS OF A DOTTED WITH COLUMNS OF B:
      IF(NRA.LT.NCAA .OR. NRB.LT.NCAA) GOTO 800
      DO 410 I = 1,NCCC
        CALL CNDOTP(A,2,LA2,B(JB),2,0,C(JC),2,NCAA,NRCC,JSW)
        JB = JB + LB2
        JC = JC + LC2
410   CONTINUE
      GOTO 800
C
600   CONTINUE
C     TRANSPOSE B ONLY:
C     ROWS OF A DOTTED WITH ROWS OF B:
      IF(NRA.LT.NRCC .OR. NRB.LT.NCCC) GOTO 800
      DO 510 I = 1,NCCC+NCCC,2
        CALL CNDOTP(A,LA2,2,B(I),LB2,0,C(JC),2,NCAA,NRCC,JSW)
        JC = JC + LC2
510   CONTINUE
      GOTO 800
C
700   CONTINUE
C     TRANSPOSE A AND B:
C     COLUMNS OF A DOTTED WITH ROWS OF B:
      IF(NRA.LT.NCAA .OR. NRB.LT.NCCC) GOTO 800
      DO 710 I = 1,NCCC+NCCC,2
        CALL CNDOTP(A,2,LA2,B(I),LB2,0,C(JC),2,NCAA,NRCC,JSW)
        JC = JC + LC2
710   CONTINUE
C
800   RETURN
      END
