C*****  CMSUFL  Complex Matrix Unsymmetric Fill-in   MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C
C       CALL CMSUFL (S,IRN,ICP,IDP,N,NS,M,VWK,LWK,T,JRN,JCP,JDP,NT,IERR)
C
C       where,
C
C       S       Complex input vector of length NS.
C               Contains the elements of the complex matrix
C               A stored in sparse symmetric format.
C
C       IRN     Integer input vector of length NS containing the
C               row number of each element stored in vector S.
C
C       ICP     Integer input vector of column pointers of length N+1.
C
C       IDP     Integer input vector of diagonal pointers of length N.
C
C       N       Integer input order of matrix A.
C
C       NS      Integer input element count of vector S.
C
C       M       Integer input maximum size of T and JRN.
C
C       VWK     Complex workspace vector of length N.
C
C       LWK     Integer workspace vector of length N.
C
C       T       Complex output vector of length NT.
C               Contains updated S with space for fill-in
C               provided in the appropriate positions.
C
C       JRN     Integer output vector of length NT containing
C               the row number of each element stored in vector T.
C
C       JCP     Integer output vector of column pointers length N+1.
C
C       JDP     Integer output vector of diagonal pointers of length N.
C
C       NT      Integer output element count of vector T.
C
C       IERR    Integer output completion code:
C                   =0 if the routine terminated normally.
C                   =1 if the routine aborted because the
C                      specified value for M was too small to
C                      accommodate all fill-in values.
C
C
C  DESCRIPTION
C
C       This routine builds the sparse unsymmetric format
C       vectors T, JRN, JCP, and JDP (with space reserved for
C       fill-in) describing matrix A.  The non-zero elements of
C       matrix A are input by vectors S, IRN, ICP, and IDP.  The
C       output vectors are in a form usable by CMSUFC and CMSUFS.
C       Output vectors must not overlay input vectors.
C
C
C  REFERENCE
C
C       D. Young.  1971.  Iterative solution of large linear
C       systems.  New York: Academic Press.
C
C       D. J. Evans (ed).  1985.  Sparsity and its applica-
C       tions.  New York: Cambridge University Press.
C
C
C  EXAMPLE
C
C       CALL CMSUFL (S,IRN,ICP,IDP,6,14,16,VWK,LWK,T,JRN,JCP,JDP,NT,
C      +             IERR)
C
C       Input Operands:
C
C       S = (10.0,12.0)      IRN = 1   ICP = 1   IDP = 1
C           (-1.0, 2.0)            2         5         6
C           ( 3.0,-3.0)            3         8        10
C           ( 1.0, 0.0)            6        12        12
C           (-1.0, 2.0)            1        13        13
C           ( 2.0, 6.0)            2        14        14
C           (-1.0, 1.0)            3        15
C           ( 3.0,-3.0)            1
C           (-1.0, 1.0)            2
C           ( 8.0,-8.0)            3
C           ( 1.0,-1.0)            5
C           ( 0.0, 2.0)            4
C           (-4.0,10.0)            5
C           ( 0.0, 4.0)            6
C
C       Output Operands:
C
C       T = (10.0,12.0)      JRN = 1   JCP = 1   JDP = 1   NT = 16
C           (-1.0, 2.0)            2         5         6
C           ( 3.0,-3.0)            3         9        11
C           ( 1.0, 0.0)            6        14        14
C           (-1.0, 2.0)            1        15        15
C           ( 2.0, 6.0)            2        16        16
C           (-1.0, 1.0)            3        17
C           ( 0.0, 0.0)  (Fill-in) 6
C           ( 3.0,-3.0)            1
C           (-1.0, 1.0)            2
C           ( 8.0,-8.0)            3
C           ( 1.0,-1.0)            5
C           ( 0.0, 0.0)  (Fill-in) 6
C           ( 0.0, 2.0)            4
C           (-4.0,10.0)            5
C           ( 0.0, 4.0)            6
C
C       IERR = 0
C
C
C  HISTORY
C         1) May 85     D. Cooper       Original.
C                       R. Coleman
C         2) Aug 85     D. Cooper       ECR 8/6/85--enhanced robustness
C                                       towards invalid IRN,ICP,IDP.
C         3) Apr 90     L. Tarvestad    Add initialization for NT and T(2).
C
      SUBROUTINE CMSUFL(S,IRN,ICP,IDP,N,NS,M,VWK,LWK,T,JRN,JCP,JDP,NT,
     +  IERR)
C
      REAL    S(1), T(1), VWK(1)
      INTEGER N,NS,IRN(1),ICP(1),IDP(1),JRN(1),JCP(1),JDP(1),NT,IERR,M
      INTEGER LWK(1),FALSE,TRUE
      INTEGER I,J,K,K1,K2
      DATA    FALSE, TRUE /0,1/
C
      IERR = 0
      NT = 0
      IF (N.LE.0 .OR. NS.LE.0 .OR. M.LT.NS) GOTO 9000
C
C ... INITIALIZE WORKSPACES ***
C
      DO 110 I = 1, N
         JDP(I) = 0
         VWK(I+I-1) = 0.0
         VWK(I+I)   = 0.0
         LWK(I) = FALSE
 110  CONTINUE
C
C ... DO FIRST COLUMN ***
C
      IF (IRN(1).EQ.1) GOTO 115
        T(1) = 0.0
        T(2) = 0.0
        JRN(1) = 1
        NT = 1
115   CONTINUE
      JCP(1) = 1
      JDP(1) = 1
      K1 = ICP(1)
      K2 = ICP(2)-1
      IF (K1.GT.K2) GOTO 125
        IF ((K2-K1+NT).LT.M) GOTO 117
          IERR = 1
          GOTO 9000
117     CONTINUE
        DO 120 K = K1,K2
          NT = NT + 1
          T(NT+NT-1) = S(K+K-1)
          T(NT+NT)   = S(K+K)
          JRN(NT) = IRN(K)
120     CONTINUE
125   CONTINUE
C
C ... START MAIN LOOP ***
C
      IF (N.LT.2) GOTO 900
      DO 180 J = 2, N
         JCP(J) = NT + 1
         K1 = ICP(J)
         K2 = ICP(J+1) - 1
         IF (K1 .GT. K2) GOTO 131
           DO 130 K = K1, K2
             I = IRN(K)
             VWK(I+I-1) = S(K+K-1)
             VWK(I+I)   = S(K+K)
             LWK(I) = TRUE
 130       CONTINUE
 131     CONTINUE
C
C ... DO FILL-IN ***
C
         DO 150 I = 1, J-1
            IF(LWK(I) .EQ. FALSE) GO TO 150
            K1 = JDP(I) + 1
            K2 = JCP(I+1) - 1
            IF(K1 .GT. K2) GO TO 150
            DO 140 K = K1, K2
               LWK(JRN(K)) = TRUE
 140        CONTINUE
 150     CONTINUE
C
C ... COMPRESS COLUMN J INTO T ***
C
         DO 170 I = 1, N
            IF(LWK(I) .EQ. FALSE) GO TO 170
            NT = NT + 1
            IF (NT.LE.M) GOTO 160
              IERR = 1
              NT = NT - 1
              GOTO 9000
160         CONTINUE
            T(NT+NT-1) = VWK(I+I-1)
            T(NT+NT)   = VWK(I+I)
            JRN(NT) = I
            IF(I .EQ. J) JDP(J) = NT
            VWK(I+I-1) = 0.0
            VWK(I+I)   = 0.0
            LWK(I) = FALSE
 170     CONTINUE
 180  CONTINUE
C
900   JCP(N+1) = NT + 1
9000  RETURN
      END
