C*****  CMSUFS  Complex Sparse Factor and Solve     MATH ADVANTAGE REL 2.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CMSUFS (S,IRN,ICP,IDP,N,NS,ZTOL,BX,M,WRK,IERR)
C
C       where,
C
C       S       Complex input/output vector of length NS.
C               On input, S contains the elements of the complex
C               matrix A stored in sparse unsymmetric format.  On
C               output, S contains the superposition of the L and U
C               factors.
C
C       IRN     Integer input vector of length NS containing
C               the row number of each element stored in S.
C
C       ICP     Integer input vector of column pointers of length
C               N+1.
C
C       IDP     Integer input vector of diagonal pointers of length N
C
C       N       Integer input order of matrix A.
C
C       NS      Integer input element count of vector S.
C
C       ZTOL    Real input scalar, diagonal element zero tolerance.
C
C       BX      Complex input/output matrix of dimension N by M.
C               On input, BX contains M right-hand sides.
C               On output, BX contains M solution vectors.
C
C       M       Integer input number of right-hand sides.
C
C       WRK     Complex workspace vector of length N.
C
C       IERR    Integer output completion code:
C                   =0 if the routine terminated normally.
C                   >0 if the routine aborted because a diagonal
C                      element was less than or equal to ZTOL.
C                      The value of IERR is the index of the column
C                      where it aborted.
C
C
C  DESCRIPTION
C
C       This routine solves the complex linear system Ax = b by
C       calling CMSUFC to factor the complex matrix A into LU form.
C       It then calls routine CMSUSV to solve the system.
C
C
C  REFERENCE
C
C       D. Young.  1971.  Iterative solution of large linear
C       systems.  New York: Academic Press.
C
C       G. W. Stewart.  1973.  Introduction to matrix computa-
C       tions.  New York: Academic Press.
C
C       D. J. Evans (ed).  1985.  Sparsity and its applica-
C       tions.  New York: Cambridge University Press.
C
C
C  EXAMPLE
C
C       CALL CMSUFS (S,IRN,ICP,IDP,6,16,ZTOL,BX,2,WRK,IERR)
C
C       Input Operands:
C
C       S = (10.0,12.0)       IRN = 1   ICP = 1   IDP = 1
C           (-1.0, 2.0)             2         5         6
C           ( 3.0,-3.0)             3         9        11
C           ( 1.0, 0.0)             6        14        14
C           (-1.0, 2.0)             1        15        15
C           ( 2.0, 6.0)             2        16        16
C           (-1.0, 1.0)             3        17
C           ( 0.0, 0.0)  (Fill-in)  6
C           ( 3.0,-3.0)             1
C           (-1.0, 1.0)             2
C           ( 8.0,-8.0)             3
C           ( 1.0,-1.0)             5
C           ( 0.0, 0.0)  (Fill-in)  6
C           ( 0.0, 2.0)             4
C           (-4.0,10.0)             5
C           ( 0.0, 4.0)             6
C
C       BX = ( 28.0, 37.0)      ( 10.0,-27.0)
C            (  7.0,-50.0)      (-49.0, 28.0)
C            (100.0,-78.0)      ( 84.0,-34.0)
C            ( -8.0, -6.0)      ( 12.0, -8.0)
C            (-40.0,-64.0)      ( 54.0,-22.0)
C            (  3.0, 20.0)      (  7.0,-12.0)
C
C       ZTOL = 1.0E-5
C
C       Output Operands:
C
C       S = ( 0.041,-0.049)
C           (-1.000, 2.000)
C           ( 3.000,-3.000)
C           ( 1.000, 0.000)
C           ( 0.057, 0.131)
C           ( 0.056,-0.145)
C           (-1.566, 0.779)
C           (-0.057,-0.131)
C           (-0.025,-0.270) (Fill-in)
C           ( 0.025, 0.270)
C           ( 0.070, 0.053)
C           ( 1.000,-1.000)
C           (-0.009, 0.289)  (Fill-in)
C           ( 0.000,-0.500)
C           (-0.034,-0.086)
C           ( 0.000,-0.250)
C
C       BX = ( 3.0, 4.0)      (-1.0, 0.0)
C            (-8.0,-7.0)      ( 2.0, 7.0)
C            ( 9.0,-1.0)      ( 8.0, 4.0)
C            (-3.0, 4.0)      (-4.0,-6.0)
C            (-3.0, 6.0)      (-3.0,-3.0)
C            ( 4.0, 0.0)      (-3.0,-2.0)
C
C       IERR = 0
C
C  HISTORY
C         1) Nov 84     D. Cooper       Original.
C                       R. Coleman
C         2) Jan 88     L. Shanbeck     Expanded IERR functionality
C
      SUBROUTINE CMSUFS(S,IRN,ICP,IDP,N,NS,ZTOL,BX,M,WRK,IERR)
C
      INTEGER M,N,NS,ICP(1),IRN(1),IDP(1),IERR
      REAL S(1),ZTOL,WRK(1),BX(1)
C
      IERR = 0
      IF (M.LE.0 .OR. N.LE.0 .OR. NS.LE.0) GOTO 900
      CALL CMSUFC(S,IRN,ICP,IDP,N,NS,ZTOL,WRK,IERR)
      IF(IERR .NE. 0) GOTO 900
      CALL CMSUSV(S,IRN,ICP,IDP,N,NS,BX,M)
900   RETURN
      END
