C*****  CMSUSV  Complex Sparse Solve              MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CMSUSV (S,IRN,ICP,IDP,N,NS,BX,M)
C
C       where,
C
C       S       Complex input vector of length NS.
C               S contains a superposition of the
C               L and U factors of A.
C
C       IRN     Integer input vector of length NS containing the
C               row number of each element stored in S.
C
C       ICP     Integer input vector of column pointers of length N+1.
C
C       IDP     Integer input vector of diagonal pointers of length N
C
C       N       Integer input order of matrix A.
C
C       NS      Integer input element count of vector S.
C
C       BX      Complex input/output matrix of dimension N by M.
C               On input, BX contains M right-hand sides. On output,
C               BX contains M solution vectors.
C
C       M       Integer input number of right-hand sides.
C
C
C  DESCRIPTION
C
C       This routine solves a complex linear system Ax = b, where A
C       has been factored into LU form by CMSUFC and is represented
C       in sparse unsymmetric format by S, IRN, ICP, and IDP.
C
C
C  REFERENCE
C
C       D. Young.  1971.  Iterative solution of large linear
C       systems.  New York: Academic Press.
C
C       G. W. Stewart.  1973.  Introduction to matrix computa-
C       tions.  New York: Academic Press.
C
C       D. J. Evans (ed).  1985.  Sparsity and its applica-
C       tions.  New York: Cambridge University Press.
C
C
C  EXAMPLE
C
C       CALL CMSUSV (S,IRN,ICP,IDP,6,16,BX,2)
C
C       Input Operands:
C
C       S = ( 0.041,-0.049)   IRN = 1  ICP = 1  IDP = 1
C           (-1.000, 2.000)         2        5        6
C           ( 3.000,-3.000)         3        9       11
C           ( 1.000, 0.000)         6       14       14
C           ( 0.057, 0.131)         1       15       15
C           ( 0.056,-0.145)         2       16       16
C           (-1.566, 0.779)         3       17
C           (-0.057,-0.131)         6
C           (-0.025,-0.270)         1
C           ( 0.025, 0.270)         2
C           ( 0.070, 0.053)         3
C           ( 1.000,-1.000)         5
C           (-0.009, 0.289)         6
C           ( 0.000,-0.500)         4
C           (-0.034,-0.086)         5
C           ( 0.000,-0.250)         6
C
C       BX = ( 28.0, 37.0)      ( 10.0,-27.0)
C            (  7.0,-50.0)      (-49.0, 28.0)
C            (100.0,-78.0)      ( 84.0,-34.0)
C            ( -8.0, -6.0)      ( 12.0, -8.0)
C            (-40.0,-64.0)      ( 54.0,-22.0)
C            (  3.0, 20.0)      (  7.0,-12.0)
C
C
C       Output Operands:
C
C       BX = ( 3.0, 4.0)        (-1.0, 0.0)
C            (-8.0,-7.0)        ( 2.0, 7.0)
C            ( 9.0,-1.0)        ( 8.0, 4.0)
C            (-3.0, 4.0)        (-4.0,-6.0)
C            (-3.0, 6.0)        (-3.0,-3.0)
C            ( 4.0, 0.0)        (-3.0,-2.0)
C
C
C  HISTORY
C         1) Nov 84     D. Cooper       Original.
C                       R. Coleman
C
      SUBROUTINE CMSUSV(S,IRN,ICP,IDP,N,NS,BX,M)
C
      INTEGER M,N,NS,I,J,K,L1,L2,NM1,IPTR,DPTR
      REAL BX(1), S(1), TMPR, TMPI, BXR, BXI
      INTEGER ICP(1), IRN(1), IDP(1), L, LM1
C
      IF(N.LE.0 .OR. NS.LE.0 .OR. M.LE.0) GOTO 900
C
      DO 850 L = 1,M*(N+N),(N+N)
        LM1 = L - 1
C       FORWARD ELIMINATION
        DO 20 J=1,N
C         FIND Y(J)
C ----    IF (CABS(BX(J)).EQ.0.0) GO TO 20
          IPTR = J+J+LM1
          IF (BX(IPTR) .EQ. 0.0 .AND. BX(IPTR-1) .EQ. 0.0) GO TO 20
C ----    BX(J) = S(IDP(J))*BX(J)
          DPTR = IDP(J)*2
          BXR = S(DPTR-1) * BX(IPTR-1) - S(DPTR) * BX(IPTR)
          BXI = S(DPTR-1) * BX(IPTR) + S(DPTR) * BX(IPTR-1)
          BX(IPTR-1) = BXR
          BX(IPTR)   = BXI
          IF (J.EQ.N) GO TO 20
C ----    TMP=BX(J)
          TMPR = BX(IPTR-1)
          TMPI = BX(IPTR)
C  ANNIHILATE JTH COLUMN BELOW DIAGONAL
          L1=IDP(J)+1
          L2=ICP(J+1)-1
          IF (L1.GT.L2) GO TO 20
          DO 10 I=L1,L2
              IPTR = IRN(I) * 2 + LM1
C ----        BX(IRN(I))=BX(IRN(I))-TMP*S(I)
              BXR = BX(IPTR-1) - (TMPR*S(I+I-1) - TMPI*S(I+I))
              BXI = BX(IPTR) - (TMPR*S(I+I) + TMPI*S(I+I-1))
              BX(IPTR-1) = BXR
              BX(IPTR)   = BXI
10        CONTINUE
20      CONTINUE
C  BACKWARD SUBSTITUTION
        IF (N.EQ.1) GOTO 850
        NM1=N-1
        DO 40 K=1,NM1
          J=N-K+1
C  ANNIHILATE JTH COLUMN ABOVE DIAGONAL
          L1=ICP(J)
          L2=IDP(J)-1
          IF (L1.GT.L2) GO TO 40
          IPTR = J+J+LM1
C ----    TMP=BX(J)
          TMPR = BX(IPTR-1)
          TMPI = BX(IPTR)
C ----    IF (CABS(TMP).EQ.0.0) GO TO 40
          IF (TMPR .EQ. 0.0 .AND. TMPI .EQ. 0.0) GO TO 40
          DO 30 I=L1,L2
              IPTR = IRN(I) * 2 + LM1
C ----        BX(IRN(I))=BX(IRN(I))-TMP*S(I)
              BXR = BX(IPTR-1) - (TMPR*S(I+I-1) - TMPI*S(I+I))
              BXI = BX(IPTR) - (TMPR*S(I+I) + TMPI*S(I+I-1))
              BX(IPTR-1) = BXR
              BX(IPTR)   = BXI
30        CONTINUE
40      CONTINUE
850   CONTINUE
900   RETURN
      END
