C*****  CMTRAN  Complex Matrix Transpose          MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CMTRAN (A,NRA,C,NRC,NRAA,NCAA,IFLG)
C
C       where,
C
C       A       Complex input matrix.
C
C       NRA     Integer input number of rows in full matrix A.
C
C       C       Complex output matrix.
C
C       NRC     Integer input number of rows in full matrix C.
C
C       NRAA    Integer input number of rows in submatrix A.
C
C       NCAA    Integer input number of columns in submatrix A.
C
C       IFLG    Integer input processing option flag:
C                   =0 for normal matrix transpose
C                   =1 for conjugate transpose
C
C
C  DESCRIPTION
C
C       This routine transposes the elements of a complex matrix A
C       and stores the results in C.  Depending on the value of
C       IFLG, C will contain either the normal transpose or conjugate
C       transpose of A.
C
C       If IFLG = 0:
C          real(C(n,i)) = real(A(i,n))
C          imag(C(n,i)) = imag(A(i,n))     for i=1,NRAA and n=1,NCAA
C
C
C       If IFLG = 1:
C          real(C(n,i)) = real(A(i,n))
C          imag(C(n,i)) =-imag(A(i,n))     for i=1,NRAA  and n=1,NCAA
C
C       A and C must not overlay each other.
C
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL CMTRAN (A,3,C,4,2,4,1)
C
C       Input Operands:
C
C       A = (1.0,2.0)  ( 7.0, 8.0)  (13.0,14.0)  (19.0,20.0)
C           (3.0,4.0)  ( 9.0,10.0)  (15.0,16.0)  (21.0,22.0)
C           (5.0,6.0)  (11.0,12.0)  (17.0,18.0)  (23.0,24.0)
C
C       Output Operands:
C
C       C = ( 1.0, -2.0)       ( 3.0, -4.0)
C           ( 7.0, -8.0)       ( 9.0,-10.0)
C           (13.0,-14.0)       (15.0,-16.0)
C           (19.0,-20.0)       (21.0,-22.0)
C
C  HISTORY
C         1) Nov 84     D. Cooper       Original.
C
      SUBROUTINE CMTRAN(A,NRA,B,NRB,NRAA,NCAA,IFLG)
C
      INTEGER NRA,NRB,NRAA,NCAA,IFLG,ROW,COL,IA,IB,LB2
      REAL A(1),B(1),CONJ
      IF (NRAA.LE.0 .OR. NCAA.LE.0 .OR.
     +  NRA.LT.NRAA .OR. NRB.LT.NCAA .OR.
     +  IFLG.LT.0 .OR. IFLG.GT.1) GO TO 200
C
C     IF IFLG=1, CONJUGATE EACH PAIR
C
      CONJ = 1.0
      IF (IFLG.EQ.1) CONJ = -1.0
C
      LB2 = NRB+NRB
      DO 30 COL = 1,NCAA+NCAA,2
        IB = COL
        IA = (COL-1)*NRA+1
        DO 20 ROW = 1,NRAA
          B(IB)   = A(IA)
          B(IB+1) = CONJ * A(IA+1)
          IA = IA + 2
          IB = IB + LB2
20      CONTINUE
30    CONTINUE
200   RETURN
      END
