C*****  CMTUSV  Complex Matrix Tridiagonal Unsym Solve     MATH ADV REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CMTUSV (AD, AU, AL, N, BX, M)
C
C       where,
C
C       AD      Complex input vector of length N.
C               AD contains the reciprocals of the main diagonal
C               of the factored matrix.
C
C       AU      Complex input vector of length N-1.
C               AU contains the reciprocals of the upper diagonal
C               of the factored matrix.
C
C       AL      Complex input vector of length N-1.
C               AL contains the reciprocals of the lower diagonal
C               of the factored matrix.
C
C       N       Integer input number of rows in full matrix.
C
C       BX      Complex input/output matrix of dimension N by M.
C               On input, BX contains M right-hand sides.
C               On output, BX contains M solution vectors.
C
C       M       Integer input number of right-hand sides.
C
C
C  DESCRIPTION
C
C       This routine solves a complex linear system Ax = b,
C       where A has been factored into LU by CMTUFC, and is
C       represented in tridiagonal format by AD, AU and AL.
C
C
C  REFERENCE
C
C       D. Young.  1971.  Iterative solution of large linear
C       systems.  New York: Academic Press.
C
C       G. W. Stewart.  1973.  Introduction to matrix computa-
C       tions.  New York: Academic Press.
C
C       D. J. Evans (ed).  1985.  Sparsity and its applica-
C       tions.  New York: Cambridge University Press.
C
C
C  EXAMPLE
C
C       CALL CMTUSV (AD, AU, AL, 5, BX, 2)
C
C       Input Operands:
C
C       AD = ( 0.0227, 0.0227)  AU = ( 0.0909, 0.2727)  AL = (-2.0,-8.0)
C            (-0.0192, 0.0165)       (-0.0109, 0.1427)       (-2.0,-9.0)
C            ( 0.0235,-0.0220)       (-0.0942, 0.0879)       ( 0.0, 3.0)
C            (-0.0407,-0.0426)       (-0.2421,-0.3386)       ( 1.0, 9.0)
C            (-0.0253,-0.0217)
C
C       BX = ( -16.0,-176.0)   (-352.0,-120.0)
C            (-111.0,-179.0)   ( 306.0, -98.0)
C            (-315.0, -18.0)   ( 175.0,-311.0)
C            ( -59.0, -42.0)   ( -60.0,-160.0)
C            ( -76.0,-103.0)   ( 181.0,  72.0)
C
C       Output Operands:
C
C       BX = ( 4.0,-6.0)   (-2.0,-10.0)
C            ( 5.0, 3.0)   (-6.0, 10.0)
C            (-7.0, 8.0)   (-5.0, -9.0)
C            (-1.0, 3.0)   (-1.0,  6.0)
C            (-1.0, 4.0)   (-5.0, -8.0)
C
C  HISTORY
C         1) Jan 88     L. Shanbeck     Original.
C                       R. Coleman
C
      SUBROUTINE CMTUSV (AD, AU, AL, N, BX, M)
C
      REAL AD(1), AU(1), AL(1), BX(1)
      REAL ADR,ADI, AUR,AUI, ALR,ALI, TMPR,TMPI, BXR,BXI
      INTEGER N, M, I, J, II, N2
C
C     DO VALIDITY CHECKS AND INITIALIZATION
C
      IF (N.LE.0  .OR. M.LE.0) GOTO 800
      IF (M .GT. 1) GO TO 200
C
C  PATH FOR M = 1
C
C  FORWARD ELIMINATION
C
      ADR = AD(1)
      ADI = AD(2)
      BXR = BX(1)
      BXI = BX(2)
      BX(1) = ADR * BXR - ADI * BXI
      BX(2) = ADR * BXI + ADI * BXR
      IF (N .EQ. 1) GO TO 800
      II = 3
C
      DO 110 I = 2, N
         ALR = AL(II-2)
         ALI = AL(II-1)
         BXR = BX(II-2)
         BXI = BX(II-1)
         TMPR = ALR * BXR - ALI * BXI
         TMPI = ALR * BXI + ALI * BXR
         BXR = BX(II) - TMPR
         BXI = BX(II+1) - TMPI
         ADR = AD(II)
         ADI = AD(II+1)
         BX(II) = ADR * BXR - ADI * BXI
         BX(II+1) = ADR * BXI + ADI * BXR
         II = II + 2
  110 CONTINUE
C
C  BACKWARD SUBSTITUTION
C
      II = II - 4
      DO 120 I = N-1, 1, -1
         AUR = AU(II)
         AUI = AU(II+1)
         BXR = BX(II+2)
         BXI = BX(II+3)
         BX(II) = BX(II) - (AUR * BXR - AUI * BXI)
         BX(II+1) = BX(II+1) - (AUR * BXI + AUI * BXR)
         II = II - 2
  120 CONTINUE
      GO TO 800
C
C  PATH FOR M > 1
C
C  FORWARD ELIMINATION
C
  200 CONTINUE
      II = 1
      ADR = AD(1)
      ADI = AD(2)
      N2 = N + N
      DO 210 J = 1, M
         BXR = BX(II)
         BXI = BX(II+1)
         BX(II) = ADR * BXR - ADI * BXI
         BX(II+1) = ADR * BXI + ADI * BXR
         II = II + N2
  210 CONTINUE
      IF (N .EQ. 1) GO TO 800
C
      DO 230 I = 2, N
         II = I*2 - 1
         ADR = AD(II)
         ADI = AD(II+1)
         ALR = AL(II-2)
         ALI = AL(II-1)
         DO 220 J = 1, M
            BXR = BX(II-2)
            BXI = BX(II-1)
            TMPR = ALR * BXR - ALI * BXI
            TMPI = ALR * BXI + ALI * BXR
            BXR = BX(II) - TMPR
            BXI = BX(II+1) - TMPI
            BX(II) = ADR * BXR - ADI * BXI
            BX(II+1) = ADR * BXI + ADI * BXR
            II = II + N2
  220    CONTINUE
  230 CONTINUE
C
C  BACKWARD SUBSTITUTION
C
      DO 250 I = N-1, 1, -1
         II = I*2-1
         AUR = AU(II)
         AUI = AU(II+1)
         DO 240 J = 1, M
            BXR = BX(II+2)
            BXI = BX(II+3)
            BX(II) = BX(II) - (AUR * BXR - AUI * BXI)
            BX(II+1) = BX(II+1) - (AUR * BXI + AUI * BXR)
            II = II + N2
  240    CONTINUE
  250 CONTINUE
C
  800 CONTINUE
      RETURN
      END
