C*****  CNFFTM  Complex Nested FFT - Mixed Radix     MTHADV EXT. REL 1.0
C
C    ** COPYRIGHT 1987 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CNFFTM (C,ICI,ICO,N,NV,IDIR,INIT,ITAB,RTAB,W,IERR)
C
C       where,
C
C       C       Complex input/output vector containing NV subvectors
C               each having a length of N.
C
C       ICI     Integer input scalar inner loop stride for vector C.  It
C               is the stride between components of the subvector.  ICI
C               must be greater than 1.
C
C       ICO     Integer input scalar outer loop stride for vector C.  It
C               is the stride between subvectors.  ICO must be greater
C               than 1.
C
C       N       Integer input scalar subvector element count.  N must be
C               factorable as integer powers of 2, 3, 5, and/or 7.
C
C       NV      Integer input scalar number of subvectors in C.
C
C       IDIR    Integer input scalar direction flag:
C                  IDIR > 0 - Perform forward FFT
C                  IDIR = 0 - No FFT performed
C                  IDIR < 0 - Perform inverse FFT
C
C       INIT    Integer input scalar initialization flag:
C                  INIT <> 0 - Initialize tables
C                  INIT =  0 - No initialization
C
C       ITAB    Integer input/output vector of length 2 * N + 34
C               containing integer constants and coefficients.
C
C       RTAB    Real input/output vector of length 2 * N + 13
C               containing real constants and coefficients.
C
C       W       Real scratch vector of length 18 * NV
C
C       IERR    Integer input scalar completion code:
C                  IERR =  0 - Normal completion
C                  IERR >  0 - Invalid value of N (see below)
C                  IERR = -1 - Invalid value of ICI (ICI<2)
C                  IERR = -2 - Invalid tables (see below)
C
C  DESCRIPTION
C
C       Performs a mixed-radix forward or inverse complex-to-complex FFT
C       on NV complex subvectors of length N.  N must be factorable by
C       2, 3, 5, and/or 7; i.e., N = 2**I * 3**J * 5**K * 7**L where I,
C       J, K, and L are non-negative integers. The results are overlaid
C       on the source vector.  The results are not properly scaled.
C
C       If INIT = 1, then tables corresponding to the specific value of
C       N are generated and are stored and returned in the vectors ITAB
C       and RTAB.  If INIT = 0, then the tables are not generated, thus,
C       tables previously generated must be supplied as inputs in ITAB
C       and RTAB.  Some values in the tables are dependent on the values
C       of the parameters ICI and IDIR.  If INIT = 0 and the tables were
C       originally generated with different values of ICI and IDIR, then
C       the tables are automatically modified.  When the tables are
C       generated, the value of N is stored in the first element of both
C       ITAB and RTAB.  If INIT = 0, then the value of N is checked
C       against the first element of both ITAB and RTAB.  If the values
C       do not match then the tables are declared to be invalid.
C
C       The parameters IDIR and INIT operate independently of each
C       other.  If both IDIR and INIT are nonzero, then the table
C       generation occurs prior to performing the FFT.  If both IDIR
C       and INIT are zero, The only action is the validity checking
C       of the parameter N.
C
C       If the value of N is invalid, then the value returned in IERR
C       is the smallest valid length that is greater than N; i.e.,
C       IERR is set to the smallest value such that IERR > N and
C       IERR = 2**I * 3**J * 5**K * 7*L where I, J, K, and L are
C       non-negative integers.
C
C  HISTORY
C       1) Jan 88       P.G. CROSE      Original
C
C-----------------------------------------------------------------------
C
      SUBROUTINE CNFFTM (C, ICI, ICO, N, NV, IDIR, INIT, ITAB, RTAB,
     *                    W, IERR)
C
C  PARAMETERS:
C
      REAL    C(*), RTAB(*), W(*)
      INTEGER ICI, ICO, N, NV, IDIR, INIT, ITAB(*), IERR
C
C  LOCAL VARIABLES:
C
      INTEGER J
C                      LOOP INDEX
      INTEGER JC
C                      POINTER TO STRIDE IN ITAB
      INTEGER JCON
C                      POINTER TO START OF CONSTANT TABLE IN RTAB
      INTEGER JCOS
C                      POINTER TO START OF COSINE TABLE IN RTAB
      INTEGER JD
C                      POINTER TO DIRECTION FLAG IN RTAB
      INTEGER JDES
C                      POINTER TO START OF DESTINATION TABLE IN ITAB
      INTEGER JF
C                      POINTER TO NUMBER OF FACTORS IN ITAB
      INTEGER JFAC
C                      POINTER TO START OF FACTOR TABLE IN ITAB
      INTEGER JN
C                      POINTER TO ELEMENT COUNT IN ITAB AND RTAB
      INTEGER JP
C                      POINTER TO NUMBER OF PERMUTATIONS IN ITAB
      INTEGER JSIN
C                      POINTER TO START OF SINE TABLE IN RTAB
      INTEGER JSRC
C                      POINTER TO START OF SOURCE TABLE IN ITAB
      INTEGER KC
C                      PREVIOUS STRIDE VALUE
      INTEGER KDIR
C                      INTERNAL DIRECTION FLAG
      INTEGER MCON
C                      SPACE RESERVED FOR CONSTANT TABLE IN RTAB
      INTEGER MFAC
C                      SPACE RESERVED FOR FACTOR TABLE IN ITAB
      INTEGER NF
C                      NUMBER OF FACTORS = ELEMENT COUNT OF FACTOR TABLE
      INTEGER NP
C                      NUMBER OF PERMUTATIONS = ELEMENT COUNT OF SOURCE
C                      AND DESTINATION TABLES
      INTEGER ISTARTW(18)
C                      STARTING INDEX FOR WORKING VECTORS OF LENGTH NV
C
      PARAMETER (JN = 1, JD = 2, JC = 2, JF = 3, JP = 4)
      PARAMETER (JCON =  3, JFAC = 5)
      PARAMETER (MCON = 11, MFAC =30)
C
C-----------------------------------------------------------------------
C
      IERR =  0
C
C  INITIALIZE TABLE POINTERS
C
      JSIN = JCON + MCON
      JCOS = JSIN + N
      JSRC = JFAC + MFAC
      JDES = JSRC + N
C
C  INITIALIZE STARTING INDEXES FOR WORKING VECTORS
C
      ISTARTW(1) = 1
      DO 10 J = 2, 18
            ISTARTW(J) = ISTARTW(J-1) + NV
 10   CONTINUE
C
C  SET INTERNAL DIRECTION FLAG
C
      IF      (IDIR .GE. 0) THEN
         KDIR =  1
      ELSE IF (IDIR .LT. 0) THEN
         KDIR = -1
      ENDIF
C
C  SELECT PATH
C
      IF      (INIT .NE. 0) THEN
         GO TO 100
      ELSE IF (IDIR .NE. 0) THEN
         GO TO 200
      ELSE
         CALL AMX000 (N, IERR)
         IF (IERR .EQ. N) IERR = 0
         GO TO 800
      ENDIF
C
C=======================================================================
C                           INITIALIZE TABLES
C=======================================================================
C
  100 CONTINUE
      ITAB(JN) = 0
      RTAB(JN) = 0.0
C
      CALL AMX001 (ICI, N, KDIR, ITAB(JFAC), NF, RTAB(JCON),
     &             RTAB(JSIN), RTAB(JCOS), ITAB(JSRC), ITAB(JDES), NP)
C
C  CHECK IF N FACTORED OK
C
      IF (NF .EQ. 0) THEN
         CALL AMX000 (N, IERR)
         GO TO 800
      ENDIF
C
C  CHECK VALIDITY OF STRIDE
C
      IF (ICI .LT. 2) THEN
         IERR = -1
         GO TO 800
      ENDIF
C
C  SAVE SOME PARAMETERS IN TABLES
C
      ITAB(JN) = N
      ITAB(JC) = ICI
      ITAB(JF) = NF
      ITAB(JP) = NP
      RTAB(JN) = FLOAT( N )
      RTAB(JD) = FLOAT( KDIR )
C
C  WHERE NOW ?
C
      IF (IDIR .NE. 0) THEN
         GO TO 300
      ELSE
         GO TO 800
      ENDIF
C
C=======================================================================
C                        MODIFY EXISTING TABLES
C=======================================================================
C
  200 CONTINUE
C
C  CHECK VALIDITY OF TABLES
C
      IF (N .NE. ITAB(JN) .OR. N .NE. IFIX( RTAB(JN) )) THEN
         IERR = -2
         GO TO 800
      ENDIF
C
      NF = ITAB(JF)
      NP = ITAB(JP)
C
C  IF DIRECTION HAS CHANGED, MODIFY RTAB
C
      IF (KDIR .NE. IFIX( RTAB(JD) )) THEN
         RTAB(JD) = FLOAT( KDIR )
C
         DO 210 J = JSIN, JSIN+N-1
            RTAB(J) = -RTAB(J)
  210    CONTINUE
C
         DO 220 J = JCON, JCON+MCON-1, 2
            RTAB(J) = -RTAB(J)
  220    CONTINUE
      ENDIF
C
C  IF STRIDE HAS CHANGED AND NEW STRIDE IS VALID, MODIFY ITAB
C
      IF (ICI .NE. ITAB(JC)) THEN
         IF (ICI .LT. 2) THEN
            IERR = -1
            GO TO 800
         ENDIF
C
         KC = ITAB(JC)
         ITAB(JC) = ICI
C
         DO 230 J = JSRC, JSRC+NP-1
            ITAB(J) = ((ITAB(J) - 1) / KC) * ICI + 1
  230    CONTINUE
C
         DO 240 J = JDES, JDES+NP-1
            ITAB(J) = ((ITAB(J) - 1) / KC) * ICI + 1
  240    CONTINUE
      ENDIF
C
C=======================================================================
C                              PERFORM FFT
C=======================================================================
C
  300 CONTINUE
 
      CALL AMX002( C(1), C(2), ICI, ICO, N, NV, KDIR, ITAB(JFAC), NF,
     &             RTAB(JCON), RTAB(JSIN), RTAB(JCOS),
     &             ITAB(JSRC), ITAB(JDES), NP,
     &             W(ISTARTW(1)), W(ISTARTW(2)), W(ISTARTW(3)),
     &             W(ISTARTW(4)), W(ISTARTW(5)), W(ISTARTW(6)),
     &             W(ISTARTW(7)), W(ISTARTW(8)), W(ISTARTW(9)),
     &             W(ISTARTW(10)), W(ISTARTW(11)), W(ISTARTW(12)),
     &             W(ISTARTW(13)), W(ISTARTW(14)), W(ISTARTW(15)),
     &             W(ISTARTW(16)), W(ISTARTW(17)), W(ISTARTW(18)) )
C
C=======================================================================
C                         EXIT ROUTINE CNFFTM
C=======================================================================
C
  800 CONTINUE
      RETURN
      END
