C*****  CONV    Convolution and Correlation           MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CONV (A,IA,B,IB,C,IC,N,M,L)
C
C       where,
C
C       A       Real input vector of length (N-1)*L+M.
C
C       IA      Integer input stride for vector A.
C
C       B       Real input vector.
C
C       IB      Integer input stride for vector B.
C                 IB >0 Perform correlation
C                 IB <0 Perform convolution
C
C       C       Real output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count for C.
C
C       M       Integer input element count for B.
C
C       L       Integer input decimation factor.
C
C
C  DESCRIPTION
C
C       Depending on the sign of IB, this routine performs either
C       a convolution or correlation on two vectors A and B and
C       stores the results in C.  Vector C may overlay vector
C       A but not vector B.
C
C       To perform a convolution, use a negative IB increment.
C       Since the stride for B is negative, B must point to the
C       last element in the vector.
C
C       A decimation factor L is specified.  If L=1, then the
C       convolution or correlation value for every position of A
C       and B is computed.  A value of L=3 indicates that only every
C       third possible output value is actually computed.
C
C       The formula for correlation is:
C
C            C(i) = SUM{A(L*(i-1)+j) * B(j)}    for j=1,M and i=1,N
C
C       The formula for convolution is:
C
C            C(i) = SUM{A(L*(i-1)+j) * B(M-j+1)}    for j=1,M and i=1,N
C
C       CONV can be used to do a FIR filter (Finite Impulse Response).
C       See DEQ22 for IIR filter (Infinite Impulse Response).
C
C
C  REFERENCE
C
C       G. W. Jenkins and D. G. Watts.  1969.  Spectral
C       analysis and its applications.  San Francisco: Holden-
C       Day.
C
C
C  EXAMPLE
C
C       For Correlation:
C
C       CALL CONV (A,1,B,1,C,1,6,5,1)
C
C       Input Operands:
C
C       A = 0.000
C           0.000
C           0.000
C           1.000
C           1.000
C           1.000
C           3.000
C           0.000
C           0.000
C           0.000
C
C       B = 0.000
C           1.000
C           2.000
C           0.000
C           0.000
C
C       Output Operands:
C
C       C = 0.000
C           2.000
C           3.000
C           3.000
C           7.000
C           3.000
C
C
C       For Convolution:
C
C       CALL CONV (A,1,B(5),-1,C,1,6,5,1)
C
C       Input Operands:
C
C       A = 0.000
C           0.000
C           0.000
C           1.000
C           1.000
C           1.000
C           3.000
C           0.000
C           0.000
C           0.000
C
C       B = 0.000
C           1.000
C           2.000
C           0.000
C           0.000
C
C       Output Operands:
C
C       C = 1.000
C           3.000
C           3.000
C           5.000
C           6.000
C           0.000
C
C
C  HISTORY
C         1) May 85     D. Cooper       Original.
C
      SUBROUTINE CONV(A,IA,B,IB,C,IC,N,M,L)
C
      INTEGER IA,IB,IC,N,M,L
      REAL A(1),B(1),C(1)
      IF (M.LE.0 .OR. N.LE.0 .OR. L.LE.0) GO TO 800
C
      CALL RNDOTP(A,IA,L*IA,B,IB,0,C,IC,M,N,0)
800   RETURN
      END
