C*****  CSPEC   Accumulating Cross-Spectrum       MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CSPEC (A,B,C,N)
C
C       where,
C
C       A       Complex input vector.
C
C       B       Complex input vector.
C
C       C       Complex input/output vector.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine performs an accumulating cross-spectrum on
C       two complex vectors A and B, and stores the results in
C       complex vector C.
C
C            real(C(i)) = real(C(i)) + real(A(i))*real(B(i))
C                         + imag(A(i))*imag(B(i))
C            imag(C(i)) = imag(C(i)) + real(A(i))*imag(B(i))
C                         - imag(A(i))*real(B(i))
C            for i=1,N
C
C
C  REFERENCE
C
C       P. Bloomfield.  1976.  Fourier analysis of time series:
C       an introduction.  New York: Wiley & Sons.
C
C
C  EXAMPLE
C
C       CALL CSPEC (A,B,C,5)
C
C       Input Operands:
C
C       A = (1.000, 2.000)
C           (3.000, 4.000)
C           (5.000, 6.000)
C           (7.000, 8.000)
C           (9.000,10.000)
C
C       B = (1.000, 2.000)
C           (3.000, 4.000)
C           (5.000, 6.000)
C           (7.000, 8.000)
C           (9.000,10.000)
C
C       C = (1.000,0.000)
C           (2.000,0.000)
C           (3.000,0.000)
C           (4.000,0.000)
C           (5.000,0.000)
C
C       Output Operands:
C
C       C = (  6.0, 0.000)
C           ( 27.0, 0.000)
C           ( 64.0, 0.000)
C           (117.0, 0.000)
C           (186.0, 0.000)
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE CSPEC(A,B,C,N)
C
      INTEGER N,IA,M
      REAL A(1),B(1),C(1)
      IF (N.LE.0) GO TO 800
      IA = 1
      DO 300 M = 1, N
        C(IA) = C(IA) + A(IA) * B(IA) + A(IA+1) * B(IA+1)
        C(IA+1) = C(IA+1) + A(IA) * B(IA+1) - A(IA+1) * B(IA)
        IA = IA + 2
300   CONTINUE
800   RETURN
      END
