C*****  CSWAP    Complex Vector Swap                    MATH ADV REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CSWAP (N,CX,INCX,CY,INCY)
C
C       where,
C
C       N       Integer input element count.
C
C       CX      Complex input/output vector.
C
C       INCX    Integer input stride for vector CX.
C
C       CY      Complex input/output vector.
C
C       INCY    Integer input stride for vector CY.
C
C
C  DESCRIPTION
C
C       This routine swaps the elements of a complex vector CX
C       with the elements of another complex vector CY.
C
C       CX(i) = CY(i)
C            and
C       CY(i) = CX(i)                for i=1,N
C
C  REFERENCE
C
C       J.J. Dongarra and C.B. Moler, J.R. Bunch, G.W. Stewart.  1979.
C       LINPACK Users' Guide.  Appendix A: Basic Linear Algebra Subprograms.
C       SIAM
C
C
C  EXAMPLE
C
C       CALL CSWAP (2,CX,1,CY,1)
C
C       Input Operands:
C
C       CX =  (1.000,-2.000)
C             (3.000,4.000)
C
C       CY =  (5.000,6.000)
C             (7.000,8.000)
C
C       Output Operands:
C
C       CX =  (5.000,6.000)
C             (7.000,8.000)
C
C       CY =  (1.000,-2.000)
C             (3.000,4.000)
C
C  HISTORY
C         1) Jan 88     L. Shanbeck     Original.
C
C
      SUBROUTINE CSWAP(N,CX,INCX,CY,INCY)
C
      COMPLEX CX(1),CY(1),CTEMP
      INTEGER N,INCX,INCY,II,KK,M
C
      IF (N.LE.0) GO TO 40
      II = 1
      KK = 1
      IF (INCX.LT.0) II = (-N+1)*INCX + 1
      IF (INCY.LT.0) KK = (-N+1)*INCY + 1
      DO 10 M=1,N
        CTEMP  = CX(II)
        CX(II) = CY(KK)
        CY(KK) = CTEMP
        II = II+INCX
        KK = KK+INCY
10    CONTINUE
40    RETURN
      END
