C*****  CTRN2   2-D Coordinate Transform          MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CTRN2 (A,B,IB,C,D,ID,N)
C
C       where,
C
C       A       Real input matrix, 2x2 rotation matrix.
C
C       B       Real input matrix, N sets of 2-element coordinate
C               vectors.
C
C       IB      Integer input stride between first elements of each
C               2-element vector of B.
C
C       C       Real input vector, 2-element translation vector.
C
C       D       Real output matrix, N sets of 2-element vectors.
C
C       ID      Integer input stride between first elements of each
C               2-element vector of D.
C
C       N       Integer input number of 2-element vectors.
C
C
C  DESCRIPTION
C
C       This routine translates and rotates a series of 2-dimensional
C       coordinates and stores the results in matrix D.
C
C            D(i) = A * (B(i) - C) for i=1,N
C
C       where,
C
C            D(i) and B(i) represent the particular set of coordinates.
C
C  REFERENCE
C
C       William M. Newman and Robert F. Sproull.  1979.  Prin-
C       ciples of interactive computer graphics.  New York:
C       McGraw-Hill.
C
C
C  EXAMPLE
C
C       CALL CTRN2 (A,B,2,C,D,2,2)
C
C       Input Operands:
C
C       A = 1.000   3.000
C           2.000   4.000
C
C       B = 5.000   3.000
C           4.000   2.000
C
C       C = 1.000
C           2.000
C
C       Output Operands:
C
C       D = 10.000   2.000
C           16.000   4.000
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE CTRN2(A,B,IB,C,D,ID,N)
C
      INTEGER IB,ID,N,JJ,LL,M
      REAL A(1),B(1),C(1),D(1),D1,D2
      IF (N.LE.0) GO TO 800
      JJ = 1
      LL = 1
      DO 120 M = 1, N
         D1 = A(1) * (B(JJ)-C(1)) + A(3) * (B(JJ+1)-C(2))
         D2 = A(2) * (B(JJ)-C(1)) + A(4) * (B(JJ+1)-C(2))
         D(LL) = D1
         D(LL+1) = D2
         JJ = JJ + IB
         LL = LL + ID
120   CONTINUE
800   RETURN
      END
