C*****  CVCOMB  Complex Vector Combine            MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CVCOMB (A,IA,B,IB,C,IC,N)
C
C       where,
C
C       A       Real input vector, real part.
C
C       IA      Integer input stride for vector A.
C
C       B       Real input vector, imaginary part.
C
C       IB      Integer input stride for vector B.
C
C       C       Complex output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine combines the elements of two real vectors
C       A and B to form a complex vector C.  The elements to
C       become the real part of C are stored in vector A.  Those
C       to become the imaginary part are stored in B.
C
C            real (C(i)) = A(i)
C            imag (C(i)) = B(i)    for i=1,N
C
C
C  REFERENCE
C
C       J. H. Matthews.  1982.  Basic complex variables for
C       mathematics and engineering.  New York: Allyn and
C       Bacon.
C
C
C  EXAMPLE
C
C       CALL CVCOMB (A,1,B,1,C,2,3)
C
C       Input Operands:
C
C       A =  1.000
C            2.000
C            3.000
C
C       B = 10.000
C           20.000
C           30.000
C
C
C       Output Operands:
C
C       C = (1.000,10.000)
C           (2.000,20.000)
C           (3.000,30.000)
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE CVCOMB(A,IA,B,IB,C,IC,N)
C
      INTEGER IA,IB,IC,N,II,JJ,KK,M
      REAL A(1),B(1),C(1)
      IF (N.LE.0) GO TO 40
      II = 1
      JJ = 1
      KK = 1
      DO 10 M=1,N
        C(KK) = A(II)
        C(KK+1) = B(JJ)
        II = II+IA
        JJ = JJ+IB
        KK = KK+IC
10    CONTINUE
40    RETURN
      END
