C*****  CVEXP   Complex Vector Exponential        MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CVEXP (A,IA,C,IC,N)
C
C       where,
C
C       A       Real input vector, in radians.
C
C       IA      Integer input stride for vector A.
C
C       C       Complex output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine computes the complex exponential of a
C       vector A and stores the results in complex vector C.
C
C            real(C(i)) = COS(A(i))
C            imag(C(i)) = SIN(A(i))    for i=1,N
C
C
C  REFERENCE
C
C       J. H. Matthews.  1982.  Basic complex variables for
C       mathematics and engineering.  New York: Allyn and
C       Bacon.
C
C
C  EXAMPLE
C
C       CALL CVEXP (A,1,C,2,2)
C
C       Input Operands:
C
C       A =  0.785
C           -0.785
C
C       Output Operands:
C
C       C = (0.707, 0.707)
C           (0.707,-0.707)
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE CVEXP(A,IA,C,IC,N)
C
      INTEGER IA,IC,N,II,KK,M
      REAL A(1),C(1)
      IF (N.LE.0) GO TO 12
      II = 1
      KK = 1
      DO 10 M=1,N
        C(KK) = COS(A(II))
        C(KK+1) = SIN(A(II))
        II = II+IA
        KK = KK+IC
10    CONTINUE
12    RETURN
      END
