C*****  CVMCO   Complex Vector Multiply, Conj. Out   MTHADV EXT. REL 1.0
C
C    ** COPYRIGHT 1986 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CVMCO (A,IA,B,IB,C,IC,N,IFLG)
C
C       where,
C
C       A       Complex input vector.
C
C       IA      Integer input stride for vector A.
C
C       B       Complex input vector.
C
C       IB      Integer input stride for vector B.
C
C       C       Complex output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C       IFLG    Integer input processing option flag:
C                   = 1 for normal complex multiply.
C                   =-1 for multiply with conjugate of A.
C
C
C  DESCRIPTION
C
C       This routine multiplies the elements of two complex vectors
C       A and B and stores the conjugate of the product in C.
C       Depending on the value of IFLG, the complex vector B is either
C       multiplied by complex vector A or by the conjugate of complex
C       vector A.
C
C       This routine is functionally identical to Math Advantage
C       routine CVMUL, except that the results have been conjugated.
C
C       If IFLG = 1
C            real(C(i)) = real(A(i))*real(B(i))-imag(A(i))*imag(B(i))
C            imag(C(i)) = -real(A(i))*imag(B(i))-imag(A(i))*real(B(i))
C            for i=1,N
C
C       If IFLG = -1
C            real(C(i)) = real(A(i))*real(B(i))+imag(A(i))*imag(B(i))
C            imag(C(i)) = -real(A(i))*imag(B(i))+imag(A(i))*real(B(i))
C            for i=1,N
C
C
C  EXAMPLE
C
C       CALL CVMCO (A,2,B,2,C,2,2,1)
C
C       Input Operands:
C
C       A = (1.000,2.000)
C           (3.000,4.000)
C
C       B = (  3.000,6.000)
C           (-12.000,9.000)
C
C       Output Operands:
C
C       C = ( -9.000,-12.000)
C           (-72.000, 21.000)
C
C  HISTORY
C         1) Oct 86     L. Tarvestad    Original.
C
C-----------------------------------------------------------------------
C
      SUBROUTINE CVMCO(A,IA,B,IB,C,IC,N,IFLG)
C
      INTEGER IA,IB,IC,N,IFLG,II,JJ,KK,M
      REAL A(1),B(1),C(1),PROD
C
C-----------------------------------------------------------------------
C
      IF (N.LE.0 .OR. (IFLG.NE.-1 .AND. IFLG.NE.1)) GO TO 40
      II = 1
      JJ = 1
      KK = 1
      IF (IFLG.EQ.-1) GOTO 20
        DO 10 M=1,N
          PROD = A(II)*B(JJ) - A(II+1)*B(JJ+1)
          C(KK+1) = -A(II)*B(JJ+1) - A(II+1)*B(JJ)
          C(KK) = PROD
          II = II+IA
          JJ = JJ+IB
          KK = KK+IC
10      CONTINUE
        GO TO 40
C
20      DO 30 M=1,N
          PROD = A(II)*B(JJ) + A(II+1)*B(JJ+1)
          C(KK+1) = -A(II)*B(JJ+1) + A(II+1)*B(JJ)
          C(KK) = PROD
          II = II+IA
          JJ = JJ+IB
          KK = KK+IC
30      CONTINUE
40    RETURN
      END
