C*****  CVRCIP  Complex Vector Reciprocal         MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CVRCIP (A,IA,C,IC,N)
C
C       where,
C
C       A       Complex input vector.
C
C       IA      Integer input stride for vector A.
C
C       C       Complex output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine computes the reciprocal of the elements
C       of a complex vector A and stores the results in C.
C
C            real(C(i)) = real(A(i)) / (real(A(i))**2+imag(A(i))**2)
C            imag(C(i)) = -imag(A(i)) / (real(A(i))**2+imag(A(i))**2)
C            for i=1,N
C
C
C  REFERENCE
C
C       J. H. Matthews.  1982.  Basic complex variables for
C       mathematics and engineering.  New York: Allyn and
C       Bacon.
C
C
C  EXAMPLE
C
C       CALL CVRCIP (A,2,C,2,2)
C
C       Input Operands:
C
C       A = ( 1.000,-2.000)
C           (-3.000, 4.000)
C
C
C       Output Operands:
C
C       C = ( 0.200, 0.400)
C           (-0.120,-0.160)
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE CVRCIP(A,IA,C,IC,N)
C
      INTEGER IA,IC,N,II,KK,M
      REAL A(1),C(1),DNOM
      IF (N.LE.0) GO TO 12
      II = 1
      KK = 1
      DO 10 M=1,N
        DNOM = A(II)*A(II) + A(II+1)*A(II+1)
        C(KK) = A(II)/DNOM
        C(KK+1) = -A(II+1)/DNOM
        II = II+IA
        KK = KK+IC
10    CONTINUE
12    RETURN
      END
