C*****  CVSMA    Complex Vector Scalar Multiply & Add  MATHADV EXT. REL 1.0
C
C
C  CALL FORMAT
C
C       CALL CSVMA (A,IA,B,C,IC,D,ID,N,IFLG)
C
C       where,
C
C       A       Complex input vector.
C
C       IA      Integer input stride for vector A.
C
C       B       Complex input scalar.
C
C       C       Complex input vector.
C
C       IC      Integer input stride for vector C.
C
C       D       Complex output vector.
C
C       ID      Integer input stride for vector D.
C
C       N       Integer input element count.
C
C       IFLG    Integer input processing option flag:
C                   = 1 for normal complex multiply.
C                   =-1 for multiply with conjugate of A.
C
C
C  DESCRIPTION
C
C       This routine multiplies the elements of a complex vector A
C       by a scalar B, and adds their products to the elements of a
C       second complex vector C.  Depending on the value of IFLG, the
C       complex vector A and scalar B are either multiplied normally
C       or B is multiplied by the conjugate of A.
C
C       If IFLG = 1
C            real(D(i)) = real(A(i))*real(B) - imag(A(i))*imag(B)
C                         + real(C(i))
C            imag(D(i)) = real(A(i))*imag(B) + imag(A(i))*real(B)
C                         + imag(C(i))
C            for i=1,N
C
C       If IFLG = -1
C            real(D(i)) = real(A(i))*real(B) + imag(A(i))*imag(B)
C                         + real(C(i))
C            imag(D(i)) = real(A(i))*imag(B) - imag(A(i))*real(B)
C                         + imag(C(i))
C            for i=1,N
C
C
C  EXAMPLE
C
C       CALL CVSMA (A,2,B,C,2,D,2,2,1)
C
C       Input Operands:
C
C       A =  (1.000,2.000)
C            (3.000,4.000)
C
C       B =  (1.000,-1.000)
C
C       C =  (10.000,20.000)
C            (30.000,40.000)
C
C       Output Operands:
C
C       D = (13.000,21.000)
C           (37.000,41.000)
C
C  HISTORY
C         1) Nov 87     P. Crose       Original.
C
C-----------------------------------------------------------------------
C
      SUBROUTINE CVSMA(A,IA,B,C,IC,D,ID,N,IFLG)
C
      INTEGER IA,IC,ID,N,IFLG,II,KK,LL,M
      REAL A(1),B(1),C(1),D(1),SUM
C
C-----------------------------------------------------------------------
C
      IF (N.LE.0 .OR. (IFLG.NE.-1 .AND. IFLG.NE.1)) GO TO 40
      II = 1
      KK = 1
      LL = 1
      IF (IFLG.EQ.-1) GOTO 20
C       ( IFLG=1 )
        DO 10 M=1,N
          SUM = C(KK) + A(II)*B(1) - A(II+1)*B(2)
          D(LL+1) = C(KK+1) + A(II)*B(2) + A(II+1)*B(1)
          D(LL) = SUM
          II = II+IA
          KK = KK+IC
          LL = LL+ID
10      CONTINUE
        GO TO 40
C     (ELSE IFLG=-1):
20      DO 30 M=1,N
          SUM = C(KK) + A(II)*B(1) + A(II+1)*B(2)
          D(LL+1) = C(KK+1) + A(II)*B(2) - A(II+1)*B(1)
          D(LL) = SUM
          II = II+IA
          KK = KK+IC
          LL = LL+ID
30      CONTINUE
40    RETURN
      END
