C*****  CVSMUL  Complex Vector Scalar Multiply    MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CVSMUL (A,IA,B,C,IC,N)
C
C       where,
C
C       A       Complex input vector.
C
C       IA      Integer input stride for vector A.
C
C       B       Real input scalar.
C
C       C       Complex output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine multiplies both the real and imaginary parts of
C       the elements of a complex vector by a real scalar B and stores
C       the results in complex vector C.
C
C            real(C(i)) = real(A(i)) * B
C            imag(C(i)) = imag(A(i)) * B    for i=1,N
C
C
C  REFERENCE
C
C       J. H. Matthews.  1982.  Basic complex variables for
C       mathematics and engineering.  New York: Allyn and
C       Bacon.
C
C
C  EXAMPLE
C
C       CALL CVSMUL (A,2,B,C,2,2)
C
C       Input Operands:
C
C       A =  (1.000,2.000)
C            (3.000,4.000)
C
C       B =  -2.000
C
C       Output Operands:
C
C       C = (-2.000,-4.000)
C           (-6.000,-8.000)
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
C
      SUBROUTINE CVSMUL(A,IA,B,C,IC,N)
C
      INTEGER IA,IC,N,II,KK,M
      REAL A(1),B,C(1)
      IF (N.LE.0) GO TO 40
      II = 1
      KK = 1
      DO 10 M=1,N
        C(KK) = B*A(II)
        C(KK+1) = B*A(II+1)
        II = II+IA
        KK = KK+IC
10    CONTINUE
40    RETURN
      END
