C*****  HILB   Construct Hilbert Transform Operator  MTHADV EXT. REL 1.0
C
C    ** COPYRIGHT 1986 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C    CALL HILB (LFM,IFLG,TDEL,F1,DB,LF,F)
C
C    where,
C
C    LFM     Integer input scalar, maximum allowable length for
C            operator.  Must be odd.
C
C    IFLG    Integer input processing flag:
C             1 for Ross weighting.
C             2 for Bessel weighting.
C
C    TDEL    Real input scalar, sample increment in seconds.
C
C    F1      Real input scalar, lower frequency where amplitude
C            spectrum will be accurate to DB decibels.  (Upper end
C            will also symetrically roll off to zero from Nyquist
C            Frequency less F1 Hertz.)
C
C    DB      Real input scalar, accuracy for filter amplitude spectrum
C            in dB.
C
C    LF      Integer output scalar, length of operator.  (If LF=LFM,
C            criteria could not be met in LFM samples.)
C
C    F       Real output vector, operator.
C
C
C  DESCRIPTION
C
C    This routine constructs the operator for the Hilbert Transform
C    filter. Operator length and weight strength are computed by HILB.
C    the user may specify either a Ross or Bessel weighting.
C
C
C  EXAMPLE
C
C       CALL HILB (9,1,TDEL,F1,DB,LF,F)
C
C       Input Operands:
C
C       TDEL = 0.006
C       F1   = 10.0
C       DB   = 15.0
C
C       Output Operands:
C
C       LF = 7
C
C       F  = 3.537e+01
C            0.000e+00
C            1.061e+02
C            0.000e+00
C           -1.061e+02
C            0.000e+00
C           -3.537e+01
C
C  HISTORY
C         1) Jul 83     K. Peacock (AMOCO)   Original.
C         2) Dec 86     L. Tarvestad         Add standard header.
C
C-----------------------------------------------------------------------
C
      SUBROUTINE HILB(LFM,IFLG,TDEL,F1,DB,LF,F)
C
      INTEGER LFM,IFLG,LF
      REAL TDEL,F1,DB,F(1)
      INTEGER N,ISTA,KFACT,JFACT,I,J,K
      REAL EX,EXX,ANUM,FACT,AK,DEN,DS,D,ARG
C
C-----------------------------------------------------------------------
C
      IF (IFLG.NE.1 .AND. IFLG.NE.2) GO TO 12
      IF (IFLG.EQ.2) GO TO 2
C
C HERE FOR ROSS WEIGHTING
    1 EX = -.93035+.010950*DB**1.605
      LF = (.012088+.0092801*DB**1.432)/(F1*TDEL)
      GO TO 3
C
C HERE FOR BESSEL WEIGHTING
    2 EX = -4.3726+.92922*DB**.599
      LF = (-.083440+.037663*DB**.986)/(F1*TDEL)
C
C COMMON CODE
    3 IF(EX.LT.0.)EX = 0.
      LF = LF/2*2+1
      IF(LF.GT.LFM)LF = LFM
      N = LF/2
      ISTA = N+2
      KFACT = 1-ISTA
      JFACT = LF+1
      DO 4 I=1,LF
    4 F(I) = 0.
      FACT = -2./(TDEL*3.1415927)
      DO 5 I=1,N,2
      J = N+1+I
      K = N+1-I
      F(J) = FACT/I
    5 F(K) = -F(J)
      IF(EX.EQ.0.) GO TO 12
C
      IF (IFLG.EQ.2) GO TO 8
C HERE FOR ROSS WEIGHTING.
    6 DO 7 I=ISTA,LF
      AK = I+KFACT
      ARG = 1.0 - (AK/N)**2
      IF ( ARG .GT. 0.0 ) THEN
             F(I) = F(I)*(ARG**EX)
      ELSE
             F(I) = 0.0
      ENDIF
      J = JFACT-I
    7 F(J) = -F(I)
      GO TO 12
C
C HERE FOR BESSEL WEIGHTING.
    8 DEN = 1.
      DS = 1.
      D = 0.
    9 D = D+2.
      DS = DS*EX*EX/(D*D)
      DEN = DEN+DS
      IF(DS.GT..2E-8*DEN) GO TO 9
      DO 11 I=ISTA,LF
      AK = I+KFACT
      ARG = 1.0 - (AK/N)**2
      IF ( ARG .GT. 0.0 ) THEN
          EXX = EX*SQRT(ARG)
      ELSE
         EXX = 0.0
      ENDIF
      ANUM = 1.
      DS = 1.
      D = 0.
   10 D = D+2.
      DS = DS*EXX*EXX/(D*D)
      ANUM = ANUM+DS
      IF(DS.GT..2E-8*ANUM) GO TO 10
      F(I) = F(I)*ANUM/DEN
      J = JFACT-I
   11 F(J) = -F(I)
C
   12 RETURN
      END
