C*****  IDAMAX  Index of Dbl Prec Real Maximum Absolute Value MATHADV REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       IMAX = IDAMAX (N,DX,INCX)
C
C       where,
C
C       N       Integer input element count.
C
C       DX      Double precision real input vector.
C
C       INCX    Integer input stride for vector DX.
C               Must be positive.
C
C
C  DESCRIPTION
C
C       This function returns the first index of the largest absolute
C       value of the elements in double precision vector DX.
C
C               IDAMAX = i
C       where DX(i) = maximum(dabs(DX(j)))     for j=1,N
C
C  REFERENCE
C
C       J.J. Dongarra and C.B. Moler, J.R. Bunch, G.W. Stewart.  1979.
C       LINPACK Users' Guide.  Appendix A: Basic Linear Algebra Subprograms.
C       SIAM
C
C
C  EXAMPLE
C
C       IMAX = IDAMAX (4,DX,1)
C
C       Input Operands:
C
C       DX =  1.000
C             7.000
C             3.000
C             5.000
C
C       Output Result:
C
C       IMAX = 2
C
C  HISTORY
C         1) Jan 88     L. Shanbeck     Original.
C
C
      INTEGER FUNCTION IDAMAX(N,DX,INCX)
C
      DOUBLE PRECISION DX(1),DMAX,ABSVAL
      INTEGER N,INCX,II,M
C
      IDAMAX = 0
      IF (N.LE.0 .OR. INCX.LE.0) GO TO 40
      IDAMAX = 1
      IF (N.EQ.1) GO TO 40
      II = 1
      DMAX = DABS(DX(II))
      DO 10 M=2,N
        II = II + INCX
        ABSVAL = DABS(DX(II))
        IF (ABSVAL.LE.DMAX) GO TO 10
        IDAMAX = M
        DMAX = ABSVAL
10    CONTINUE
40    RETURN
      END
