C*****  LVNE    Logical Vector Not Equal          MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL LVNE (A,IA,B,IB,C,IC,N)
C
C       where,
C
C       A       Real input vector.
C
C       IA      Integer input stride for vector A.
C
C       B       Real input vector.
C
C       IB      Integer input stride for vector B.
C
C       C       Real output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine compares the elements of two vectors,
C       and sets the corresponding elements of the output
C       vector to 1.0 if not equal.
C
C            C(i) = 1.0, if A(i) <> B(i),
C                 = 0.0, if A(i) = B(i),    for i=1,N
C
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL LVNE (A,1,B,1,C,1,5)
C
C       Input Operands:
C
C       A = 1.000
C           2.000
C           3.000
C           4.000
C           5.000
C
C       B = 5.000
C           4.000
C           3.000
C           2.000
C           1.000
C
C       Output Operands:
C
C       C = 1.000
C           1.000
C           0.000
C           1.000
C           1.000
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE LVNE(A,IA,B,IB,C,IC,N)
C
      INTEGER IA,IB,IC,N,II,JJ,KK,M
      REAL A(1),B(1),C(1)
      IF (N.LE.0) GO TO 12
      II = 1
      JJ = 1
      KK = 1
      DO 10 M=1,N
        IF (A(II).EQ.B(JJ)) GOTO 6
          C(KK) = 1.0
        GOTO 8
6         C(KK) = 0.0
8       II = II+IA
        JJ = JJ+IB
        KK = KK+IC
10    CONTINUE
12    RETURN
      END
