C****** MOMNT4    FIND FOURTH AND LOWER MOMENTS ABOUT MEAN    MTADV EXT  REL 1.0
C
C      ** COPYRIGHT 1988  QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C        CALL MOMNT4 (A, IA, AMEAN, AMOM2, AMOM3, AMOM4, N)
C
C        where,
C
C        A        Real input vector
C
C        IA       Integer input stride for A.
C
C        AMEAN    Real output mean of selected elements of A.
C
C        AMOM2    Real output second moment about the mean
C
C        AMOM3    Real output third moment about the mean
C
C        AMOM4    Real output forth moment about the mean
C
C        N        Integer input number of elements in A.
C
C  DESCRIPTION
C
C        This routine will find the forth, third and second moments about
C        the mean.  The kth moment of A (a vector) about X (a scaler) is
C        defined as:
C
C                           N
C                          SUM { ( A(i) - X )**k }/N
C                          i=1
C
C        It is more efficent to construct moments about the mean from the
C        moments about the origin.  Note that if N is less than or equal to
C        zero, this routine immediately exits.
C
C  REFERENCE
C
C        W. H. Beyer, 1966, CRC Handbook of Tables for Probability and
C        Statistics (Chemical Rubber Co., Cleveland, Ohio) page 3.
C
C  EXAMPLE
C
C        CALL MOMNT4 (A, 1, AMEAN, AMOM2, AMOM3, AMOM4, 5)
C
C        Input Operands:
C
C              A = (2.000)
C                  (3.000)
C                  (3.000)
C                  (6.000)
C                  (4.000)
C
C
C        Output Operands:
C
C              AMEAN  =  3.59999990E+00
C
C              AMOM2  =  1.84000004E+00
C
C              AMOM3  =  1.87199998E+00
C
C              AMOM4  =  8.00319958E+00
C
C  C
C        INTRINSICS:   FLOAT
C
C  HISTORY
C        (1) MAY 88           T.G. Mattson           Original
C
C-----------------------------------------------------------------------
C
      SUBROUTINE MOMNT4 (A, IA, AMEAN, AMOM2, AMOM3, AMOM4, N)
C
      REAL    A(*), AMEAN, AMOM2, AMOM3, AMOM4
      INTEGER IA, N, J, JA
C
      DOUBLE PRECISION DNRCIP, SUM1, SUM2, SUM3, SUM4,
     &               AJ, AJSQ, ANU1, ANU2, ANU3, ANU4, ANU1SQ
C
C-----------------------------------------------------------------------
C
      IF (N .LE. 0) GO TO 800
C
      DNRCIP = 1.0D0 / FLOAT( N )
C
      SUM1 = 0.0D0
      SUM2 = 0.0D0
      SUM3 = 0.0D0
      SUM4 = 0.0D0
      JA   = 1
      DO 110 J = 1, N
         AJ   = A(JA)
         AJSQ = AJ * AJ
         SUM1 = SUM1 + AJ
         SUM2 = SUM2 + AJSQ
         SUM3 = SUM3 + AJSQ * AJ
         SUM4 = SUM4 + AJSQ * AJSQ
         JA   = JA + IA
  110 CONTINUE
C
C  Compute the moments about the origin
C
      ANU1   = SUM1 * DNRCIP
      ANU2   = SUM2 * DNRCIP
      ANU3   = SUM3 * DNRCIP
      ANU4   = SUM4 * DNRCIP
      ANU1SQ = ANU1 * ANU1
C
C  Compute moments about the mean
C
      AMEAN   = ANU1
      AMOM2   = ANU2 - ANU1SQ
      AMOM3   = ANU3 - 3.0D0 * ANU1 * ANU2 + 2.0D0 * ANU1SQ * ANU1
      AMOM4   = ANU4 - 4.0D0 * ANU1 * ANU3 + 6.0D0 * ANU1SQ * ANU2
     &              - 3.0D0 * ANU1SQ * ANU1SQ
C
  800 CONTINUE
      RETURN
      END
