C*****  PSORT   Vector Partial Sort              MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL PSORT (A,IB,C,N,M)
C
C       where,
C
C       A       Real input/output vector of length N.
C               The order will be modified.
C
C       IB      Integer input vector containing the set of indices,
C               in ascending order, such that the output vector C will
C               be rearranged for the indices described in vector IB.
C               This vector will be M long for a partial sort or
C               one (a dummy integer) for a total sort.
C
C       C       Real output vector of length M for partial sort (M>0),
C               or real output vector of length N for total sort (M=0).
C
C       N       Integer input element count of vector A.
C
C       M       Integer input element count for number of elements
C               in vector A to sort for partial sort,
C               or, if M=0, then the entire vector A is sorted
C               and the IB vector is ignored.
C
C
C  DESCRIPTION
C
C       This routine does a partial or total ascending order sort of
C       the elements of vector A. The sorted elements are returned in
C       vector C.  For a partial sort, the elements of IB are used as
C       the indices of the elements of vector A which are to be
C       returned in C.  For example, if only the smallest and largest
C       elements are to be returned out of a group of 10 numbers, IB
C       would contain 2 elements with the values 1 and 10.
C
C       A total sort of the vector A is indicated by an input of 0 for
C       scaler M.  In the case of a total sort, M=0, the vector IB is
C       ignored.
C
C
C  REFERENCES
C
C       S.R. Singleton. 1969 Alogoritm 347 Sort. Comm. ACM 12:185-186.
C
C       S.S. Wilks. 1962. Mathematical Statistics. 234. New York:Wiley.
C
C
C  EXAMPLE
C
C       For a partial sort:
C
C       CALL PSORT (A,IB,C,10,5)
C
C       Input Operands:
C
C       A =  10.000   IB = 1
C            23.000        2
C             2.000        3
C           -10.000        4
C            13.000        5
C            15.000
C            36.000
C            19.000
C            20.000
C            33.000
C
C       Output Operands:
C
C       C = -10.000
C             2.000
C            10.000
C            13.000
C            15.000
C
C       For a total sort:
C
C       CALL PSORT (A,IB,C,10,0)
C
C       Input Operands:
C
C       A =  10.000   IB not used
C            23.000
C             2.000
C           -10.000
C            13.000
C            15.000
C            36.000
C            19.000
C            20.000
C            33.000
C
C       Output Operands:
C
C       C = -10.000
C             2.000
C            10.000
C            13.000
C            15.000
C            19.000
C            20.000
C            23.000
C            33.000
C            36.000
C
C
C  HISTORY
C         1) Feb 88     C. Ward         Original.
C
C
      SUBROUTINE PSORT(A,IB,C,N,M)
C
      INTEGER INDU(32),INDL(32),IU(32),IL(32)
      INTEGER IM,I,II,IJ,J,JL,JU,K,L
      INTEGER N,M,P,IB(1)
      REAL A(1),C(1),T,TT
C
      IF (N.LE.0 .OR. M.LT.0) GO TO 999
C
      IF (M.NE.0) THEN
C
      JL=1
      JU=M
      INDL(1)=1
      INDU(1)=M
C Arrays INDL,INDU Keep account of the portion of IB related to the
C current segment of data being ordered.
C
      I=1
      J=N
      IM=1
 5    IF(I.GE.J) GOTO 70
C First order A(I),A(J),A((I+J)/2), and use median to split the data
 10   K=I
      IJ=(I+J)/2
      T=A(IJ)
      IF (A(I).LE.T) GOTO 20
      A(IJ)=A(I)
      A(I)=T
      T=A(IJ)
 20   L=J
      IF (A(J).GE.T) GOTO 40
      A(IJ)=A(J)
      A(J)=T
      T=A(IJ)
      IF (A(I).LE.T) GOTO 40
      A(IJ)=A(I)
      A(I)=T
      T=A(IJ)
      GOTO 40
 30   A(L)=A(K)
      A(K)=TT
 40   L=L-1
      IF (A(L).GT.T) GOTO 40
      TT=A(L)
C Split the data into A(I to L).LT.T, A(K to J).GT.T
 50   K=K+1
      IF (A(K).LT.T) GOTO 50
      IF (K.LE.L) GOTO 30
      INDL(IM)=JL
      INDU(IM)=JU
      P=IM
      IM=IM+1
C Split the larger of the segments
      IF (L-I.LE.J-K) GOTO 60
      IL(P)=I
      IU(P)=L
      I=K
C Skip all  segments not corresponding to an entry in IB
 55   IF (JL.GT.JU) GOTO 70
      IF (IB(JL).GE.I) GOTO 58
      JL=JL+1
      GOTO 55
 58   INDU(P)=JL-1
      GOTO 80
 60   IL(P)=K
      IU(P)=J
      J=L
 65   IF (JL.GT.JU) GOTO 70
      IF (IB(JU).LE.J) GOTO 68
      JU=JU-1
      GOTO 65
 68   INDL(P)=JU+1
      GOTO 80
 70   IM=IM-1
      IF (IM.EQ.0) THEN
         DO 222 II=1,M
 222        C(II)=A(IB(II))
         CONTINUE
         RETURN
      ENDIF
      I=IL(IM)
      J=IU(IM)
      JL=INDL(IM)
      JU=INDU(IM)
      IF (JL.GT.JU) GOTO 70
 80   IF (J-I.GT.10) GOTO 10
      IF (I.EQ.1) GOTO 5
      I=I-1
 90   I=I+1
      IF (I.EQ.J) GOTO 70
      T=A(I+1)
      IF (A(I).LE.T) GOTO 90
      K=I
 100  A(K+1)=A(K)
      K=K-1
      IF (T.LT.A(K)) GOTO 100
      A(K+1)=T
      GOTO 90
      ELSE
C
C   DO A COMPLETE SORT OF THE WHOLE ARRAY
C
      JL=1
      JU=N
      INDL(1)=1
      INDU(1)=N
C Arrays INDL,INDU Keep account of the portion of IB related to th
C current segment of data being ordered.
C
      I=1
      J=N
      IM=1
 15   IF(I.GE.J) GOTO 170
C First order A(I),A(J),A((I+J)/2), and use median to split the data
 110  K=I
      IJ=(I+J)/2
      T=A(IJ)
      IF (A(I).LE.T) GOTO 120
      A(IJ)=A(I)
      A(I)=T
      T=A(IJ)
 120  L=J
      IF (A(J).GE.T) GOTO 140
      A(IJ)=A(J)
      A(J)=T
      T=A(IJ)
      IF (A(I).LE.T) GOTO 140
      A(IJ)=A(I)
      A(I)=T
      T=A(IJ)
      GOTO 140
 130  A(L)=A(K)
      A(K)=TT
 140  L=L-1
      IF (A(L).GT.T) GOTO 140
      TT=A(L)
C Split the data into A(I to L).LT.T, A(K to J).GT.T
 150  K=K+1
      IF (A(K).LT.T) GOTO 150
      IF (K.LE.L) GOTO 130
      INDL(IM)=JL
      INDU(IM)=JU
      P=IM
      IM=IM+1
C Split the larger of the segments
      IF (L-I.LE.J-K) GOTO 160
      IL(P)=I
      IU(P)=L
      I=K
C Skip all  segments not corresponding to an entry in IB
 155  IF (JL.GT.JU) GOTO 170
      IF (JL.GE.I) GOTO 158
      JL=JL+1
      GOTO 155
 158  INDU(P)=JL-1
      GOTO 180
 160  IL(P)=K
      IU(P)=J
      J=L
 165  IF (JL.GT.JU) GOTO 170
      IF (JU.LE.J) GOTO 168
      JU=JU-1
      GOTO 165
 168  INDL(P)=JU+1
      GOTO 180
 170  IM=IM-1
      IF (IM.EQ.0) THEN
          DO 444 II=1,N
             C(II)=A(II)
 444      CONTINUE
          RETURN
      ENDIF
      I=IL(IM)
      J=IU(IM)
      JL=INDL(IM)
      JU=INDU(IM)
      IF (JL.GT.JU) GOTO 170
 180  IF (J-I.GT.10) GOTO 110
      IF (I.EQ.1) GOTO 15
      I=I-1
 190  I=I+1
      IF (I.EQ.J) GOTO 170
      T=A(I+1)
      IF (A(I).LE.T) GOTO 190
      K=I
 1100 A(K+1)=A(K)
      K=K-1
      IF (T.LT.A(K)) GOTO 1100
      A(K+1)=T
      GOTO 190
      ENDIF
999   RETURN
      END
