C*****  QTC027  MATH ADVANTAGE Private Subroutine RANDN
C **** QTC027(=RANDN)       Normal random number generator     MATH
C                       ADVANTAGE REL 3.0
C   ** COPYRIGHT 1986 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C   CALL FORMAT
C
C      X = QTC027(I,AMEAN,SDEV)
C
C      where,
C
C      X      Real output value
C
C      I      Integer seed value
C
C      AMEAN  Mean of normal distribution
C
C      SDEV   Standard deviation of normal distribution
C
C
C   DESCRIPTION
C
C      This function returns a pseudo-random number, normally distributed
C      with a mean of AMEAN and a standard deviation of SDEV.  This function
C      uses the MATH ADVANTAGE function QTC026() to generate the pseudorandom
C      value.
C
C      If a value is chosen for ISEED, then repeated calls to this
C      function are made, a particular sequence of values will be returned.
C      Each different value of ISEED will result in a different sequence
C      of values - however, the sequence is identical each time a particular
C      value of ISEED is used.
C
C      The values returned by this routine are not truly random, but
C      cyclic.  However, the cycle length exceeds 2**31, which should be
C      adequate for most purposes.
C
C      This routine is slow.  Use of this routine is advisable only when
C      no system-supplied normal random number generator is available, or
C      when the randomness of the system-supplied generator is not
C      adequate.
C
C
C   EXAMPLE
C
C      I = 1234
C      AMEAN = 1.0
C      SDEV = 0.5
C      X = QTC027(I,AMEAN,SDEV)
C
C
C   HISTORY
C
C      1) August 1986       L. A. Westerman
C
 
       REAL FUNCTION QTC027(ISEED,AMEAN,SDEV)
 
       INTEGER ISEED
       REAL AMEAN, SDEV, QTC026
 
       INTEGER I
C
C      DETERMINE A GAUSSIAN RANDOM NUMBER BY ADDING 12 UNIFORMLY
C      DISTRIBUTED NUMBERS TOGETHER
C
       QTC027 = 0.0
       DO 10 I = 1, 12
              QTC027 = QTC027 + QTC026(ISEED)
10     CONTINUE
 
C
C      QTC027 VALUE HAS MEAN 6.0, DEVIATION 1.0.  TRANSFORM TO MEAN
C      AMEAN, DEVIATION SDEV
C
       QTC027 = AMEAN + ( SDEV * ( QTC027 - 6.0 ) )
 
       RETURN
       END
