C*****  QTC040  MATH ADVANTAGE Private Subroutine HTRIDI
C       (EISPACK , August 1983 Version)
C
C  MODIFICATIONS to Standard EISPACK
C
C         o Store complex data as adjacent real/imaginary pairs, instead
C           of using one array for real components and a different array
C           for imaginary components.  This was implemented by, for
C           example, replacing the declarations AR(NM,N) and AI(NM,N)
C           with the declaration AA(2,NM,N).  All subsequent references
C           to AR(i,j) are replaced with AA(1,i,j), and all references
C           to AI(i,j) are replaced with AA(2,i,j).  The related change
C           is also made in the subroutine parameter list.
C
C  HISTORY
C         1) Sep 86     L. Tarvestad    Original.
C
      SUBROUTINE QTC040(NM,N,AA,D,E,E2,TAU)
C
      INTEGER I,J,K,L,N,II,NM,JP1
      REAL AA(2,NM,N),D(N),E(N),E2(N),TAU(2,N)
      REAL F,G,H,FI,GI,HH,SI,SCALE,QTC041
C
C     THIS SUBROUTINE IS A TRANSLATION OF A COMPLEX ANALOGUE OF
C     THE ALGOL PROCEDURE TRED1, NUM. MATH. 11, 181-195(1968)
C     BY MARTIN, REINSCH, AND WILKINSON.
C     HANDBOOK FOR AUTO. COMP., VOL.II-LINEAR ALGEBRA, 212-226(1971).
C
C     THIS SUBROUTINE REDUCES A COMPLEX HERMITIAN MATRIX
C     TO A REAL SYMMETRIC TRIDIAGONAL MATRIX USING
C     UNITARY SIMILARITY TRANSFORMATIONS.
C
C     ON INPUT
C
C        NM MUST BE SET TO THE ROW DIMENSION OF TWO-DIMENSIONAL
C          ARRAY PARAMETERS AS DECLARED IN THE CALLING PROGRAM
C          DIMENSION STATEMENT.
C
C        N IS THE ORDER OF THE MATRIX.
C
C        AR AND AI CONTAIN THE REAL AND IMAGINARY PARTS,
C          RESPECTIVELY, OF THE COMPLEX HERMITIAN INPUT MATRIX.
C          ONLY THE LOWER TRIANGLE OF THE MATRIX NEED BE SUPPLIED.
C
C     ON OUTPUT
C
C        AR AND AI CONTAIN INFORMATION ABOUT THE UNITARY TRANS-
C          FORMATIONS USED IN THE REDUCTION IN THEIR FULL LOWER
C          TRIANGLES.  THEIR STRICT UPPER TRIANGLES AND THE
C          DIAGONAL OF AR ARE UNALTERED.
C
C        D CONTAINS THE DIAGONAL ELEMENTS OF THE THE TRIDIAGONAL MATRIX.
C
C        E CONTAINS THE SUBDIAGONAL ELEMENTS OF THE TRIDIAGONAL
C          MATRIX IN ITS LAST N-1 POSITIONS.  E(1) IS SET TO ZERO.
C
C        E2 CONTAINS THE SQUARES OF THE CORRESPONDING ELEMENTS OF E.
C          E2 MAY COINCIDE WITH E IF THE SQUARES ARE NOT NEEDED.
C
C        TAU CONTAINS FURTHER INFORMATION ABOUT THE TRANSFORMATIONS.
C
C     CALLS QTC041 FOR  SQRT(A*A + B*B) .
C
C     QUESTIONS AND COMMENTS SHOULD BE DIRECTED TO BURTON S. GARBOW,
C     MATHEMATICS AND COMPUTER SCIENCE DIV, ARGONNE NATIONAL LABORATORY
C
C     THIS VERSION DATED AUGUST 1983.
C
C     ------------------------------------------------------------------
C
      TAU(1,N) = 1.0
      TAU(2,N) = 0.0
C
      DO 100 I = 1, N
  100 D(I) = AA(1,I,I)
C     .......... FOR I=N STEP -1 UNTIL 1 DO -- ..........
      DO 300 II = 1, N
         I = N + 1 - II
         L = I - 1
         H = 0.0
         SCALE = 0.0
         IF (L .LT. 1) GO TO 130
C     .......... SCALE ROW (ALGOL TOL THEN NOT NEEDED) ..........
         DO 120 K = 1, L
  120    SCALE = SCALE + ABS(AA(1,I,K)) + ABS(AA(2,I,K))
C
         IF (SCALE .NE. 0.0) GO TO 140
         TAU(1,L) = 1.0
         TAU(2,L) = 0.0
  130    E(I) = 0.0
         E2(I) = 0.0
         GO TO 290
C
  140    DO 150 K = 1, L
            AA(1,I,K) = AA(1,I,K) / SCALE
            AA(2,I,K) = AA(2,I,K) / SCALE
            H = H + AA(1,I,K) * AA(1,I,K) + AA(2,I,K) * AA(2,I,K)
  150    CONTINUE
C
         E2(I) = SCALE * SCALE * H
         G = SQRT(H)
         E(I) = SCALE * G
         F = QTC041(AA(1,I,L),AA(2,I,L))
C     .......... FORM NEXT DIAGONAL ELEMENT OF MATRIX T ..........
         IF (F .EQ. 0.0) GO TO 160
         TAU(1,L) = (AA(2,I,L) * TAU(2,I) - AA(1,I,L) * TAU(1,I)) / F
         SI = (AA(1,I,L) * TAU(2,I) + AA(2,I,L) * TAU(1,I)) / F
         H = H + F * G
         G = 1.0 + G / F
         AA(1,I,L) = G * AA(1,I,L)
         AA(2,I,L) = G * AA(2,I,L)
         IF (L .EQ. 1) GO TO 270
         GO TO 170
  160    TAU(1,L) = -TAU(1,I)
         SI = TAU(2,I)
         AA(1,I,L) = G
  170    F = 0.0
C
         DO 240 J = 1, L
            G = 0.0
            GI = 0.0
C     .......... FORM ELEMENT OF A*U ..........
            DO 180 K = 1, J
               G = G + AA(1,J,K) * AA(1,I,K) + AA(2,J,K) * AA(2,I,K)
               GI = GI - AA(1,J,K) * AA(2,I,K) + AA(2,J,K) * AA(1,I,K)
  180       CONTINUE
C
            JP1 = J + 1
            IF (L .LT. JP1) GO TO 220
C
            DO 200 K = JP1, L
               G = G + AA(1,K,J) * AA(1,I,K) - AA(2,K,J) * AA(2,I,K)
               GI = GI - AA(1,K,J) * AA(2,I,K) - AA(2,K,J) * AA(1,I,K)
  200       CONTINUE
C     .......... FORM ELEMENT OF P ..........
  220       E(J) = G / H
            TAU(2,J) = GI / H
            F = F + E(J) * AA(1,I,J) - TAU(2,J) * AA(2,I,J)
  240    CONTINUE
C
         HH = F / (H + H)
C     .......... FORM REDUCED A ..........
         DO 260 J = 1, L
            F = AA(1,I,J)
            G = E(J) - HH * F
            E(J) = G
            FI = -AA(2,I,J)
            GI = TAU(2,J) - HH * FI
            TAU(2,J) = -GI
C
            DO 260 K = 1, J
               AA(1,J,K) = AA(1,J,K) - F * E(K) - G * AA(1,I,K)
     X                           + FI * TAU(2,K) + GI * AA(2,I,K)
               AA(2,J,K) = AA(2,J,K) - F * TAU(2,K) - G * AA(2,I,K)
     X                           - FI * E(K) - GI * AA(1,I,K)
  260    CONTINUE
C
  270    DO 280 K = 1, L
            AA(1,I,K) = SCALE * AA(1,I,K)
            AA(2,I,K) = SCALE * AA(2,I,K)
  280    CONTINUE
C
         TAU(2,L) = -SI
  290    HH = D(I)
         D(I) = AA(1,I,I)
         AA(1,I,I) = HH
         AA(2,I,I) = SCALE * SQRT(H)
  300 CONTINUE
C
      RETURN
      END
