C*****  QTC041  MATH ADVANTAGE Private Subroutine PYTHAG
C       (EISPACK , August 1983 Version)
C
C  MODIFICATIONS to Standard EISPACK
C
C         o None.
C
C  HISTORY
C         1) Sep 86     L. Tarvestad    Original.
C         2) Feb 88     L. Shanbeck     Changed loop exit check
C
      REAL FUNCTION QTC041(A,B)
      REAL A,B
C
C     FINDS SQRT(A**2+B**2) WITHOUT OVERFLOW OR DESTRUCTIVE UNDERFLOW
C
      REAL P,R,S,T,U
      REAL EPS,TINY,HUGE
      P = AMAX1(ABS(A),ABS(B))
      IF (P .EQ. 0.0) GO TO 20
C
C     FIND EPS, WHICH IS A SMALL EPSILON BETWEEN REAL NUMBERS
C
      CALL QTC045(EPS,TINY,HUGE)
      R = (AMIN1(ABS(A),ABS(B))/P)**2
C
C     LOOP UNTIL R APPROACHES ZERO
C
   10 IF (R .GT. -EPS .AND. R .LT. EPS) GO TO 20
         T = 4.0 + R
         S = R/T
         U = 1.0 + 2.0*S
         P = U*P
         R = (S/U)**2 * R
      GO TO 10
   20 QTC041 = P
      RETURN
      END
