C***** QTC053  FIND PRIME FACTORS              REV 1.0     JAN 88
C
C  PURPOSE:
C       FINDS THE PRIME FACTORS OF N THAT ARE LESS THAN OR EQUAL TO 7.
C
C  LANGUAGE:
C       FORTRAN 77
C
C  HISTORY:
C       ORIGINAL                DEC 86          D.R. BENUA, QTC
C       MATH ADVANTAGE VERSION  JAN 88          R.D. COLEMAN, QTC
C          CHANGED SUBROUTINE NAMES AND HEADER.
C
C  CALLING FORMAT:
C       CALL QTC053 (N, NFAC, M)
C
C  PARAMETERS:
C
C       N       INTEGER INPUT SCALAR
C               NUMBER TO BE FACTORED
C
C       NFAC    INTEGER OUTPUT ARRAY OF LENGTH M
C               PRIME FACTORS OF N.
C
C       M       INTEGER OUTPUT SCALAR
C               NUMBER OF FACTORS IN ARRAY NFAC.
C
C  DESCRIPTION:
C       This routine finds the prime factors of N, less than or equal to
C       7.  If N cannot be factored with the primes 2, 3, 5, and 7 the
C       routine returns M = 0.  Otherwise, the prime factors of N are
C       loaded into the array NFAC().  M is the number of factors.  This
C       routine is CALLed by QTC051 to initialize the factor table.
C
C  SUBPROGRAMS CALLED:
C       NONE
C
C  ERROR CONDITIONS:
C       IF N IS NOT FACTORABLE BY 2, 3, 5, OR 7, THEN M IS SET TO 0.
C
C---------------------------------------------------------------------
C
        SUBROUTINE QTC053 (N, NFAC, M)
C
        INTEGER NFAC(1)
        INTEGER N, M, NTMP
C
        NTMP = N
        M = 0
C
10      IF ((NTMP/2)*2 .NE. NTMP) GOTO 20
                NTMP = NTMP / 2
                M = M + 1
                NFAC(M) = 2
                GOTO 10
C
20      IF ((NTMP/3)*3 .NE. NTMP) GOTO 30
                NTMP = NTMP / 3
                M = M + 1
                NFAC(M) = 3
                GOTO 20
C
30      IF ((NTMP/5)*5 .NE. NTMP) GOTO 40
                NTMP = NTMP / 5
                M = M + 1
                NFAC(M) = 5
                GOTO 30
C
40      IF ((NTMP/7)*7 .NE. NTMP) GOTO 50
                NTMP = NTMP / 7
                M = M + 1
                NFAC(M) = 7
                GOTO 40
C
50      IF (NTMP .EQ. 1) RETURN
C
        M = 0
        RETURN
C
        END
