C***** QTC063  BUILD LOWER ADJACENCY STRUCTURE REV 1.0         JAN 88
C
C  PURPOSE:
C       BUILDS THE LOWER ADJACENCY STRUCTURE FOR A GRAPH GIVEN THE
C       ADJACENCY IN LINKED LIST FORM.
C
C  LANGUAGE:
C       FORTRAN 77
C
C  HISTORY:
C       ORIGINAL                JAN 88          R.D. COLEMAN, QTC
C
C  CALLING FORMAT:
C       CALL QTC063 (IHEAD, IADJ, JADJ, IWRK, N, NE, MAX)
C
C  PARAMETERS:
C       IHEAD   INTEGER INPUT VECTOR OF LENGTH N
C               POINTERS TO THE HEAD OF THE LIST FOR EACH NODE.
C
C       IADJ    INTEGER OUTPUT VECTOR OF LENGTH N+1
C               POINTERS INTO THE ADJACENCY VECTOR.
C
C       JADJ    INTEGER INPUT/OUTPUT VECTOR OF LENGTH MAX
C               ON INPUT, JADJ CONTAINS THE LINKED LISTS IN THE LAST
C               2*NE ELEMENTS.  ON OUTPUT, JADJ CONTAINS THE LOWER
C               ADJACENCY STRUCTURE OF THE GRAPH IS STORED IN THE
C               FIRST NE ELEMENTS.
C
C       N       INTEGER INPUT SCALAR
C               NUMBER OF NODES IN THE GRAPH.
C
C       NE      INTEGER OUTPUT SCALAR
C               NUMBERS OF EDGES IN THE GRAPH.
C
C       MAX     INTEGER INPUT SCALAR
C               LAST ELEMENT IN JADJ.  MAX > 2*NE.
C
C  DESCRIPTION:
C       BUILDS THE LOWER ADJACENCY STRUCTURE FOR A GRAPH IN-PLACE
C       GIVEN THE ADJACENCY IN LINKED LIST FORM.
C
C  REFERENCE:
C       Alan George and Joseph W-H. Liu.  1981.  Computer Solution of
C       Large Sparse Positive Definite Systems, Prentice-Hall, Englewood
C       Cliffs, N.J. (1981)
C
C  SUBPROGRAMS CALLED:
C       QTC064
C
C  ERROR CONDITIONS:
C       NONE
C
C-----------------------------------------------------------------------
C
      SUBROUTINE QTC063 (IHEAD, IADJ, JADJ, N, NE, MAX)
C
      INTEGER IHEAD(1), IADJ(1), JADJ(1), N, NE, MAX
      INTEGER I, KE, KL, L, MAXL, ME
C
C-----------------------------------------------------------------------
C
      ME   = NE
      MAXL = MAX - 2 * ME
C
      L  = 0
      DO 120 I = 1, N
         IADJ(I) = L + 1
C
  110    CONTINUE
         KE = IHEAD(I)
         IF (KE .NE. 0) THEN
            IF (L .GE. MAXL) THEN
               CALL QTC064 (IHEAD, JADJ, N, ME, MAX, 0)
               MAXL = MAX - 2 * ME
               KE   = IHEAD(I)
            ENDIF
C
            KL = KE + 1
            L  = L  + 1
            JADJ(L)  = JADJ(KE)
            IHEAD(I) = JADJ(KL)
            JADJ(KE) = 0
            JADJ(KL) = 0
            GO TO 110
         ENDIF
  120 CONTINUE
C
      IADJ(N+1) = L + 1
      RETURN
      END
