C***** QTC066  GENERAL REVERSE CUTHILL MCKEE   REV 1.0         JAN 88
C
C  PURPOSE:
C       FINDS THE REVERSE CUTHILL MCKEE REORDING FOR A GENERAL GRAPH.
C
C  LANGUAGE:
C       FORTRAN 77
C
C  HISTORY:
C       ORIGINAL                JAN 88          THOMAS COLEMAN, QTC
C
C  CALLING FORMAT:
C       CALL QTC066 (N, IADJ, JADJ, IPERMR, IPERMF, ILS)
C
C  PARAMETERS:
C       N       INTEGER INPUT SCALAR
C               NUMBER OF EQUATIONS.
C
C       IADJ    INTEGER INPUT VECTOR OF LENGTH N+1
C               CONTAINS POINTERS INTO THE ADJACENCY VECTOR, JADJ.
C               IADJ(N+1) = 2*NE+1, WHERE NE IS THE NUMBER OF EDGES.
C
C       JADJ    INTEGER INPUT VECTOR OF LENGTH 2*NE
C               CONTAINS THE ADJACENCY STRUCTURE OF THE GRAPH.
C
C       IPERMR  INTEGER OUTPUT VECTOR OF LENGTH N
C               THE REVERSE PERMUTATION VECTOR.
C
C       IPERMF  INTEGER OUTPUT VECTOR OF LENGTH N
C               THE FORWARD PERMUTATION VECTOR.
C
C       ILS     INTEGER SCRATCH VECTOR OF LENGTH N
C               THE INDEX VECTOR FOR THE LEVEL STRUCTURE.  THE LEVEL
C               STRUCTURE IS STORE IN THE CURRENTLY UNUSED SPACES OF
C               THE PERMUTATION VECTOR IPERMR.
C
C  DESCRIPTION:
C       THIS SUBROUTINE FINDS THE REVERSE CUTHILL MCKEE ORDERING OF
C       A GENERAL DISCONNECTED GRAPH.  IPERMF IS USED TEMPORARILY
C       TO MASK VARIABLES THAT HAVE BEEN NUMBERED DURING THE NUMBERING
C       PROCESS.  AT THE END OF THE SUBROUTINE, IPERMF IS
C       SET TO THE FOWARD PERMUTATION.  THE SUBROUTINE BEGINS BY
C       SETTING ALL VALUES OF IPERMF TO ONE.  IT THEN LOOPS THROUGH
C       IPERMF UNTIL IT FINDS AN I FOR WHICH MASK(I) = 1; NODE I
C       ALONG WITH IPERMF (SERVING AS THE MASK), IADJ, AND JADJ
C       WILL SPECIFY A CONNECTED SUBGRAPH OF THE ORIGINAL GRAPH.
C       THE SUBROUTINES QTC067 AND QTC069 ARE THEN CALLED TO ORDER
C       THE NODES OF THAT SUBGRAPH.
C
C  REFERENCE:
C       Alan George and Joseph W-H. Liu.  1981.  Computer Solution of
C       Large Sparse Positive Definite Systems, Prentice-Hall, Englewood
C       Cliffs, N.J. (1981)
C
C  SUBPROGRAMS CALLED:
C       QTC067, QTC069
C
C  ERROR CONDITIONS:
C       NONE
C
C-----------------------------------------------------------------------
C
      SUBROUTINE QTC066 ( N, IADJ, JADJ, IPERMR, IPERMF, ILS )
C
      INTEGER N, IADJ(1), JADJ(1), IPERMR(1), IPERMF(1), ILS(1),
     &        I, ICCSIZ, IROOT, NLVL, NUM
C
C-----------------------------------------------------------------------
C
      DO 110 I = 1, N
         IPERMF(I) = 1
  110 CONTINUE
C
      NUM = 1
      DO 210 I = 1, N
C
C        -----------------------------------
C        FOR EACH MASKED CONNECTED COMPONENT
C        -----------------------------------
C
         IF ( IPERMF(I) .EQ. 1 ) THEN
C
C           ------------------------------------------
C           FIRST FIND A PSEUDO-PERIPHERAL NODE IROOT.
C           NOTE THAT THE LEVEL STRUCTURE FOUND BY
C           QTC067 IS STORED STARTING AT IPERMR(NUM).
C           THEN QTC069 IS CALLED TO ORDER THE COMPONENT
C           USING IROOT AS THE STARTING NODE.
C           ------------------------------------------
C
            IROOT = I
            CALL QTC067 ( IROOT, IADJ, JADJ, IPERMF,
     &                    NLVL, ILS, IPERMR(NUM) )
            CALL QTC069 ( IROOT, IADJ, JADJ, IPERMF,
     &                    IPERMR(NUM), ICCSIZ, ILS )
            NUM = NUM + ICCSIZ
            IF (NUM .GT. N) GO TO 300
         ENDIF
  210 CONTINUE
C
  300 CONTINUE
      DO 310 I = 1, N
         IPERMF(IPERMR(I)) = I
  310 CONTINUE
C
      RETURN
      END
