C***** QTC069  REVERSE CUTHILL MCKEE           REV 1.0         JAN 88
C
C  PURPOSE:
C       THIS SUBROUTINE NUMBERS A CONNECTED COMPONENT SPECIFIED BY
C       MASK AND ROOT.  THE NUMBERING IS TO BE STARTED AT THE NODE
C       ROOT.
C
C  LANGUAGE:
C       FORTRAN 77
C
C  HISTORY:
C       ORIGINAL                JAN 88          THOMAS COLEMAN, QTC
C
C  CALLING FORMAT:
C       CALL QTC069 (IROOT, IADJ, JADJ, MASK, PERM, ICCSIZ, DEG)
C
C  PARAMETERS:
C       IROOT   INTEGER INPUT SCALAR
C               THE NODE THAT DEFINES THE CONNECTED COMPONENT
C               AND IT IS USED AS THE STARTING NODE FOR THE
C               ORDERING
C
C       IADJ    INTEGER INPUT VECTOR OF LENGTH N+1
C               CONTAINS POINTERS INTO THE ADJACENCY VECTOR, JADJ.
C               IADJ(N+1) = 2*NE+1, WHERE NE IS THE NUMBER OF EDGES.
C
C       JADJ    INTEGER INPUT VECTOR OF LENGTH 2*NE
C               CONTAINS THE ADJACENCY STRUCTURE OF THE GRAPH.
C
C       MASK    INTEGER INPUT/OUTPUT VECTOR OF LENGTH N
C               ONLY THOSE NODES WITH NONZERO INPUT MASK VALUES ARE
C               CONSIDERED BY THE ROUTINE. THE NODES NUMBERED BY THIS
C               ROUTINE WILL HAVE THEIR MASK VALUES SET TO ZERO.
C
C       IPERMR  INTEGER OUTPUT VECTOR OF LENGTH N
C               THE ARRAY CONTAINING THE REVERSE PERMUTATION VECTOR.
C
C       ICCSIZ  INTEGER OUTPUT SCALAR
C               THE SIZE OF THE CONNECTED COMPONENT THAT HAS
C               BEEN ORDERED.
C
C       IDEG    INTEGER SCRATCH VECTOR OF LENGTH N
C               A TEMPORARY VECTOR USED TO HOLD THE DEGREE OF THE NODES
C               IN THE SECTION GRAPH SPECIFIED BY MASK AND IROOT.
C
C  DESCRIPTION:
C       THIS SUBROUTINE APPLIES THE REVERSE CUTHILL MCKEE ALGORITHM
C       TO A CONNECTED COMPONENT OF A SUBGRAPH.  IT OPERATES ON A
C       CONNECTED COMPONENT SPECIFIED BY THE INPUT PARAMETERS IROOT,
C       MASK, IADJ, AND JADJ.  THE STARTING NODE IS IROOT.
C
C  REFERENCE:
C       Alan George and Joseph W-H. Liu.  1981.  Computer Solution of
C       Large Sparse Positive Definite Systems, Prentice-Hall, Englewood
C       Cliffs, N.J. (1981)
C
C  SUBPROGRAMS CALLED:
C       QTC070
C
C  ERROR CONDITIONS:
C       NONE
C
C-----------------------------------------------------------------------
C
      SUBROUTINE QTC069 (IROOT, IADJ, JADJ, MASK, IPERMR, ICCSIZ, IDEG)
C
      INTEGER IROOT, IADJ(1), JADJ(1), MASK(1), IPERMR(1), ICCSIZ,
     &        IDEG(1), I, INBR, J, JSTOP, JSTRT, K, L, LNBR, LPERM,
     &        LVLBEG, LVLEND, NBR, NODE
C
C-----------------------------------------------------------------------
C
C     -------------------------------------
C     FIND THE DEGREES OF THE NODES IN THE
C     COMPONENT SPECIFIED BY MASK AND IROOT
C     -------------------------------------
C
      CALL QTC070 ( IROOT, IADJ, JADJ, MASK, IDEG,
     &              ICCSIZ, IPERMR)
C
      MASK(IROOT) = 0
      IF (ICCSIZ .LE. 1) GOTO 800
C
      LVLEND = 0
      LNBR   = 1
C
C     --------------------------------------------
C     LVLBEG AND LVLEND POINT TO THE BEGINNING AND
C     END OF THE CURRENT LEVEL RESPECTIVELY.
C     --------------------------------------------
C
  100 CONTINUE
      LVLBEG = LVLEND + 1
      LVLEND = LNBR
      DO 140 I = LVLBEG, LVLEND
C
C        ------------------------------
C        FOR EACH NODE IN CURRENT LEVEL
C        ------------------------------
C
         NODE  = IPERMR(I)
         JSTRT = IADJ(NODE)
         JSTOP = IADJ(NODE+1) - 1
C
C        ------------------------------------------------
C        FIND THE UNNUMBERED NEIGHBORS OF NODE
C        INBR AND LNBR POINT TO THE FIRST AND LAST
C        UNNUMBERED NEIGHBORSS RESPECTIVELY OF THE CURRENT
C        NODE IN IPERMR.
C        -------------------------------------------------
C
         INBR = LNBR + 1
         DO 110 J = JSTRT, JSTOP
            NBR = JADJ(J)
            IF ( MASK(NBR) .NE. 0 ) THEN
               LNBR         = LNBR + 1
               MASK(NBR)    = 0
               IPERMR(LNBR) = NBR
            ENDIF
  110    CONTINUE
C
         IF ( INBR .LT. LNBR ) THEN
C
C           ------------------------------------------
C           SORT THE NEIGHBORS OF NODE IN INCREASING
C           ORDER BY DEGREE. LINEAR INSERTION IS USED.
C           ------------------------------------------
C
            K = INBR
C
  120       CONTINUE
               L   = K
               K   = K + 1
               NBR = IPERMR(K)
C
  130          CONTINUE
               IF ( L .GE. INBR ) THEN
                  LPERM = IPERMR(L)
                  IF (IDEG(LPERM) .GT. IDEG(NBR)) THEN
                      IPERMR(L+1) = LPERM
                      L = L - 1
                      GO TO 130
                  ENDIF
               ENDIF
C
               IPERMR(L+1) = NBR
               IF ( K .LT. LNBR ) GO TO 120
C
         ENDIF
C
  140 CONTINUE
C
      IF (LNBR .GT. LVLEND) GO TO 100
C
C     ---------------------------------------
C     WE NOW HAVE THE CUTHILL MCKEE ORDERING.
C     REVERSE IT BELOW...
C     ---------------------------------------
C
      K = ICCSIZ / 2
      L = ICCSIZ
      DO 210 I = 1, K
         LPERM     = IPERMR(L)
         IPERMR(L) = IPERMR(I)
         IPERMR(I) = LPERM
         L         = L - 1
  210 CONTINUE
C
  800 CONTINUE
      RETURN
      END
