C***** QTC071  MINIMUM DEGREE ORDERING   REV 1.0               JAN 88
C
C  PURPOSE:
C       IMPLIMENTS THE MINIMUM DEGREE ALGORITHM
C
C  LANGUAGE:
C       FORTRAN 77
C
C  HISTORY:
C       ORIGINAL                JAN 88          THOMAS COLEMAN, QTC
C
C  CALLING FORMAT:
C       CALL QTC071 (N, IADJ, JADJ, IPERMR, IPERMF, IDGREE, MARKER,
C      &             IRCHST, NBRHD, IQSIZE, IQLINK)
C
C  PARAMETERS:
C       N       INTEGER INPUT SCALAR
C               NUMBER OF EQUATIONS
C
C       IADJ    INTEGER INPUT VECTOR OF LENGTH N+1
C               CONTAINS POINTERS INTO THE ADJACENCY VECTOR, JADJ.
C               IADJ(N+1) = 2*NE+1, WHERE NE IS THE NUMBER OF EDGES.
C
C       JADJ    INTEGER INPUT VECTOR OF LENGTH 2*NE
C               CONTAINS THE ADJACENCY STRUCTURE OF THE GRAPH.
C
C       IPERMR  INTEGER OUTPUT VECTOR OF LENGTH N
C               THE REVERSE PERMUTATION VECTOR.
C
C       IPERMF  INTEGER OUTPUT VECTOR OF LENGTH N
C               THE FORWARD PERMUTATION VECTOR.
C
C       IDGREE  INTEGER SCRATCH VECTOR OF LENGTH N
C               THE DEGREE VECTOR.  DEG(I) IS NEGATIVE MEANS NODE I
C               HAS BEEN NUMBERED.
C
C       MARKER  INTEGER SCRATCH VECTOR OF LENGTH N
C               A MARKER VECTOR.  WHERE MARKER(I) IS NEGATIVE, NODE I
C               HAS BEEN MERGED WITH ANOTHER NODE AND CAN THUS BE IGNORED.
C
C       IRCHST  INTEGER SCRATCH VECTOR OF LENGTH N
C               THE VECTOR USED FOR THE REACHABLE SET.
C
C       NBRHD   INTEGER SCRATCH VECTOR OF LENGTH N
C               VECTOR USED FOR THE NEIGHBORHOOD SET.
C
C       IQLINK  INTEGER SCRATCH VECTOR OF LENGTH N
C               VECTOR USED TO STORE INDISTIGUISHABLE NODES,
C               I, IQLINK(I), QLINK(QLINK(I))... ARE THE MEMBERS
C               OF THE SUPERNODE REPESENTED BY I.
C
C       IQSIZE  INTEGER SCRATCH VECTOR OF LENGTH N
C               VECTOR USED TO STORE THE SIZE OF INDISTIGUISHABLE
C               SUPERNODES.
C
C  DESCRIPTION:
C       THIS ROUTINE IMPLIMENTS THE MINIMUM DEGREE ALGORITHM.  IT
C       MAKES USE OF THE IMPLICIT REPRESENTATION OF THE NOTION OF
C       OF THE ELIMINATION GRAPHS BY QUOTIENT GRAPHS, AND THE
C       NOTION OF INDISTIGUISHABLE NODES.
C       CAUTION - THE ADJACENCY VECTOR JADJ WILL BE DESTROYED
C
C  REFERENCE:
C       Alan George and Joseph W-H. Liu.  1981.  Computer Solution of
C       Large Sparse Positive Definite Systems, Prentice-Hall, Englewood
C       Cliffs, N.J. (1981)
C
C  SUBPROGRAMS CALLED:
C       QTC072, QTC074, QTC075
C
C  ERROR CONDITIONS:
C       NONE
C
C-----------------------------------------------------------------------
C
      SUBROUTINE QTC071 (N, IADJ, JADJ, IPERMR, IPERMF, IDGREE,
     &                   MARKER, IRCHST, NBRHD, IQSIZE, IQLINK)
C
      INTEGER N, IADJ(1), JADJ(1), IPERMR(1), IPERMF(1), IDGREE(1),
     &        MARKER(1), IRCHST(1), NBRHD(1), IQSIZE(1), IQLINK(1),
     &        INODE, IP, IRCH, IRCHSZ, ISRCH, ITHRSH, J, MINDEG, NDEG,
     &        NHDSZE, NODE, NP, NUM, NUMP1, NXNODE
C
C-----------------------------------------------------------------------
C
C     -----------------------------------------------------
C     INITIALIZE DEGREE VECTOR AND OTHER WORKING VARIABLES.
C     -----------------------------------------------------
C
      MINDEG = N
      DO 110 NODE = 1, N
         IPERMR(NODE) = NODE
         IPERMF(NODE) = NODE
         MARKER(NODE) = 0
         IQSIZE(NODE) = 1
         IQLINK(NODE) = 0
         NDEG         = IADJ(NODE+1) - IADJ(NODE)
         IDGREE(NODE) = NDEG
         IF (NDEG .LT. MINDEG) MINDEG = NDEG
  110 CONTINUE
C
C     --------------------------------------------------------
C     PERFORM THRESHOLD SEARCH TO GET A NODE OF MIN DEGREE
C     VARIABLE SEARCH POINTS TO WHERE SEARCH WOULD START.
C     --------------------------------------------------------
C
      NUM = 0
C
  200 CONTINUE
         ISRCH = 1
         ITHRSH = MINDEG
         MINDEG = N
C
  210    CONTINUE
         NUMP1 = NUM + 1
         IF (NUMP1 .GT. ISRCH) ISRCH = NUMP1
C
         DO 220 J = ISRCH, N
            NODE = IPERMR(J)
            IF (MARKER(NODE) .GE. 0) THEN
               NDEG = IDGREE(NODE)
               IF (NDEG .LE. ITHRSH) GO TO 300
               IF (NDEG .LT. MINDEG) MINDEG = NDEG
            ENDIF
  220    CONTINUE
C
         GO TO 200
C
C     --------------------------------------------------
C     NODE HAS MINIMUM DEGREE.  FIND ITS REACHABLE SETS
C     BY CALLING QTC074.
C     --------------------------------------------------
  300 CONTINUE
      ISRCH        = J
      MARKER(NODE) = 1
      CALL QTC074 (NODE, IADJ, JADJ, IDGREE, MARKER,
     &             IRCHSZ, IRCHST, NHDSZE, NBRHD)
C
C     ------------------------------------------------
C     ELIMINATE ALL NODES INDISTINGUISHABLE FROM NODE.
C     THEY ARE GIVEN BY NODE, IQLINK(NODE),...
C     ------------------------------------------------
C
      NXNODE = NODE
C
  310 CONTINUE
         NUM            = NUM + 1
         NP             = IPERMF(NXNODE)
         IP             = IPERMR(NUM)
         IPERMR(NP)     = IP
         IPERMF(IP)     = NP
         IPERMR(NUM)    = NXNODE
         IPERMF(NXNODE) = NUM
         IDGREE(NXNODE) = - 1
         NXNODE         = IQLINK(NXNODE)
         IF (NXNODE .GT. 0) GO TO 310
C
      IF (IRCHSZ .GT. 0) THEN
C
C        ----------------------------------------------------
C        UPDATE THE DEGREES OF THE NODES IN THE REACHABLE
C        SET AND IDENTIFY INDISTIGUISHABLE NODES.
C        ----------------------------------------------------
C
         CALL QTC072 (IADJ, JADJ, IRCHSZ, IRCHST, IDGREE,
     &                IQSIZE, IQLINK, MARKER,
     &                IRCHST(IRCHSZ+1), NBRHD(NHDSZE+1))
C
C        -------------------------------------------
C        RESET MARKER VALUE OF NODES IN REACH SET.
C        UPDATE THRESHOLD VALUE FOR CYCLIC SEARCH.
C        ALSO CALL QTC075 TO FORM NEW IQUOTIENT GRAPH.
C        -------------------------------------------
         MARKER(NODE) = 0
C
         DO 320 IRCH = 1, IRCHSZ
            INODE = IRCHST(IRCH)
            IF (MARKER(INODE) .GE. 0) THEN
               MARKER(INODE) = 0
               NDEG = IDGREE(INODE)
               IF (NDEG .LT. MINDEG) MINDEG = NDEG
               IF (NDEG .LE. ITHRSH) THEN
                  MINDEG = ITHRSH
                  ITHRSH = NDEG
                  ISRCH = IPERMF(INODE)
               ENDIF
            ENDIF
  320    CONTINUE
C
         IF (NHDSZE .GT. 0) CALL QTC075 (NODE, IADJ, JADJ, MARKER,
     &                                   IRCHSZ, IRCHST, NBRHD)
C
      ENDIF
C
      IF (NUM .LT. N) GO TO 210
C
      RETURN
      END
