C***** QTC072  MINIMUM DEGREE UPDATE           REV 1.0         JAN 88
C
C  PURPOSE:
C       PERFORMS DEGREE UPDATE FOR A SET OF NODES IN THE MINIMUM
C       DEGREE ALGORITHM
C
C  LANGUAGE:
C       FORTRAN 77
C
C  HISTORY:
C       ORIGINAL                JAN 88          THOMAS COLEMAN, QTC
C
C  CALLING FORMAT:
C       CALL QTC072 (IADJ, JADJ, NLIST, LIST, IDGREE, IQSIZE, IQLINK,
C                    MARKER, IRCHST, NBRHD)
C
C  PARAMETERS:
C       IADJ    INTEGER INPUT VECTOR OF LENGTH N+1
C               CONTAINS POINTERS INTO THE ADJACENCY VECTOR, JADJ.
C               IADJ(N+1) = 2*NE+1, WHERE NE IS THE NUMBER OF EDGES.
C
C       JADJ    INTEGER INPUT VECTOR OF LENGTH 2*NE
C               CONTAINS THE ADJACENCY STRUCTURE OF THE GRAPH.
C
C       NLIST   INTEGER INPUT SCALAR
C               THE NUMBER OF NODES IN LIST.
C
C       LIST    INTEGER INPUT VECTOR OF LENGTH N
C               THE LIST OF NODES WHOSE DEGREE HAS TO BE UPDATED.
C
C       IDGREE  INTEGER INPUT/OUTPUT VECTOR OF LENGTH N
C               THE DEGREE VECTOR.
C
C       IQSIZE  INTEGER INPUT/OUTPUT VECTOR OF LENGTH N
C               SIZE OF INDISTIGUISHABLE SUPERNODES.
C
C       IQLINK  INTEGER INPUT/OUTPUT VECTOR OF LENGTH N
C               LINKED LIST FOR INDISTIGUISHABLE SUPERNODES.
C
C       MARKER  INTEGER INPUT/OUTPUT VECTOR OF LENGTH N
C               A MARKER VECTOR.  USED TO MARK THOSE NODES IN
C               REACH/NBRHD SETS.
C
C       IRCHST  INTEGER SCRATCH VECTOR OF LENGTH N
C               THE VECTOR USED FOR THE REACHABLE SET.
C
C       NBRHD   INTEGER SCRATCH VECTOR OF LENGTH N
C               THE NEIGHBORHOOD SET.
C
C  DESCRIPTION:
C       THIS SUBROUTINE PERFORMS PERFORMS A DEGREE UPDATE.  THE NODES
C       WHOSE NEW DEGREES ARE TO BE DETERMINED ARE GIVEN BY THE PAIR
C       (NLIST, LIST).  THE SUBROUTINE ALSO MERGES INDISTIGUISHABLE
C       NODES IN THIS SUBSET.  THE FIRST LOOP (DO 120) AND THE CALL TO
C       SUBROUTINE QTC073 DETERMINE GROUPS OF INDISTIGUISHABLE NODES
C       IN THE GIVEN SET.  THEY WILL BE MERGED TOGETHER AND HAVE THEIR
C       DEGREES UPDATED.  FOR THE NODES NOT BEING MERGED, THE LOOP
C       DO 230 DETERMINES THEIR NEW DEGREES BY CALLING QTC074.  THE
C       VECTORS IRCHST AND NBRHD ARE USED AS TEMPORARY ARRAYS.
C
C  REFERENCE:
C       Alan George and Joseph W-H. Liu.  1981.  Computer Solution of
C       Large Sparse Positive Definite Systems, Prentice-Hall, Englewood
C       Cliffs, N.J. (1981)
C
C  SUBPROGRAMS CALLED:
C       QTC073, QTC074
C
C  ERROR CONDITIONS:
C       NONE
C
C-----------------------------------------------------------------------
C
      SUBROUTINE QTC072 (IADJ, JADJ, NLIST, LIST, IDGREE,
     &                   IQSIZE, IQLINK, MARKER, IRCHST, NBRHD)
C
      INTEGER IADJ(1), JADJ(1), NLIST, LIST(1), IDGREE(1), IQSIZE(1),
     &        IQLINK(1), MARKER(1), IRCHST(1), NBRHD(1),
     &        IDEG0, IDEG1, IL, INHD, INODE, IRCH, IRCHSZ,
     &        J, JSTRT, JSTOP, MARK, NABOR, NHDSZE, NODE
C
C-----------------------------------------------------------------------
C
C     ------------------------------------------------
C     FIND ALL ELIMINATED SUPERNODES THAT ARE ADJACENT
C     TO SOME NODES IN THE GIVEN LIST, PUT THEM INTO
C     (NHDSZE, NBRHD).  IDEG0 CONTAINS THE NUMBER OF
C     NODES IN THE LIST.
C     ------------------------------------------------
C
      IF (NLIST .LE. 0) GO TO 800
C
      IDEG0  = 0
      NHDSZE = 0
C
      DO 120 IL = 1, NLIST
         NODE  = LIST(IL)
         IDEG0 = IDEG0 + IQSIZE(NODE)
         JSTRT = IADJ(NODE)
         JSTOP = IADJ(NODE+1) - 1
C
         DO 110 J = JSTRT, JSTOP
            NABOR = JADJ(J)
            IF (MARKER(NABOR) .EQ. 0 .AND. IDGREE(NABOR) .LT. 0) THEN
               MARKER(NABOR) = -1
               NHDSZE        = NHDSZE + 1
               NBRHD(NHDSZE) = NABOR
            ENDIF
  110    CONTINUE
  120 CONTINUE
C
C     -----------------------------------------
C     MERGE INDISTIGUISHABLE NODES IN THE LIST
C     CALLING THE SUBROUTINE QTC073
C     -----------------------------------------
C
      IF (NHDSZE .GT. 0) CALL QTC073 (IADJ, JADJ, IDGREE, IQSIZE,
     &    IQLINK, MARKER, IDEG0, NHDSZE, NBRHD, IRCHST, NBRHD(NHDSZE+1))
C
C     -----------------------------------------------------
C     FIND THE NEW DEGREES OF THE NODES THAT HAVE NOT BEEN
C     MERGED
C     -----------------------------------------------------
C
      DO 230 IL = 1, NLIST
        NODE = LIST(IL)
        MARK = MARKER(NODE)
C
        IF (MARK .LE. 1 .AND. MARK .GE. 0) THEN
           MARKER(NODE) = 2
           CALL QTC074 (NODE, IADJ, JADJ, IDGREE, MARKER,
     &                   IRCHSZ, IRCHST, NHDSZE, NBRHD)
           IDEG1 = IDEG0
C
           IF (IRCHSZ .GT. 0) THEN
              DO 210 IRCH = 1, IRCHSZ
                 INODE         = IRCHST(IRCH)
                 IDEG1         = IDEG1 + IQSIZE(INODE)
                 MARKER(INODE) = 0
  210         CONTINUE
           ENDIF
C
           IDGREE(NODE) = IDEG1 - 1
C
           IF (NHDSZE .GT. 0) THEN
              DO 220 INHD = 1, NHDSZE
                 INODE         = NBRHD(INHD)
                 MARKER(INODE) = 0
  220         CONTINUE
           ENDIF
         ENDIF
  230 CONTINUE
C
  800 CONTINUE
      RETURN
      END
