C*****  RECT    Polar to Rectangular Conversion   MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL RECT (A,IA,C,IC,N)
C
C       where,
C
C       A       Complex input vector.
C
C       IA      Integer input stride for vector A.
C
C       C       Complex output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine converts the elements of a complex vector
C       from polar to rectangular form and stores the results
C       in complex vector C.
C
C            real(C(i)) = real(A(i)) * COS(imag(A(i)))
C            imag(C(i)) = real(A(i)) * SIN(imag(A(i)))    for i=1,N
C
C
C  REFERENCE
C
C       J. H. Matthews.  1982.  Basic complex variables for
C       mathematics and engineering.  New York: Allyn and
C       Bacon.
C
C
C  EXAMPLE
C
C       CALL RECT (A,2,C,2,2)
C
C       Input Operands:
C
C       A = (1.414, 0.785)
C           (2.828,-0.785)
C
C       Output Operands:
C
C       C = (1.000, 1.000)
C           (2.000,-2.000)
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE RECT(A,IA,C,IC,N)
C
      INTEGER IA,IC,N,II,KK,M
      REAL A(1),C(1),REL
      IF (N.LE.0) GO TO 12
      II = 1
      KK = 1
      DO 10 M=1,N
        REL = A(II) * COS(A(II+1))
        C(KK+1) = A(II) * SIN(A(II+1))
        C(KK) = REL
        II = II+IA
        KK = KK+IC
10    CONTINUE
12    RETURN
      END
