C*****  RFFTM   Real FFT - Mixed-Radix               MATH ADV   REL 3.0
C
C    ** COPYRIGHT 1988 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL RFFTM (C,N,IDIR,INIT,ITAB,RTAB,IERR)
C
C       where,
C
C       C       Real input/output vector.
C
C       N       Integer input real element count.
C               N must be factorable as integer powers
C               of 2, 3, 5 and/or 7.
C
C       IDIR    Integer input direction flag:
C                  IDIR > 0 - perform forward FFT
C                  IDIR = 0 - no FFT performed
C                  IDIR < 0 - perform inverse FFT
C
C       INIT    Integer input Initialization flag:
C                  INIT <> 0 - initialize tables
C                  INIT =  0 - no initialization
C
C       ITAB    Integer input/output vector of length N + 34
C               Integer initialization tables.
C
C       RTAB    Real input/output vector of length (3/2) * N + 13
C               Real initialization tables
C
C       IERR    Integer output completion code:
C                  IERR =  0 - normal completion
C                  IERR >  0 - invalid value of N (see below)
C                  IERR = -2 - invalid tables (see below)
C
C  DESCRIPTION:
C
C       This routine performs a mixed-radix real-to-complex forward FFT
C       on a real vector of length N or a mixed-radix complex-to-real
C       inverse FFT on a complex vector of length N/2, depending on the
C       value of IDIR.  The results are overlaid on the source vector C
C       in a special packed complex array format.  See RFFTSC for details
C       on the packed format.  The results are not properly scaled and
C       may be scaled using RFFTSC to multiply by 1/(2*N).
C
C       The parameters IDIR and INIT operate independently of one another.
C       If INIT is nonzero, then tables corresponding to the specific
C       value of N are generated, stored and returned in the vectors ITAB
C       and RTAB.  If INIT = 0, then ITAB and RTAB are not generated, thus,
C       tables previously generated must be supplied as inputs in ITAB
C       and RTAB.  The tables generated by this routine may not be used
C       as input to the Math Advantage routine CFFTM.
C
C       If INIT = 0 and the tables were originally generated with a
C       different value of IDIR, then the tables are automatically modified.
C       When the tables are generated, the value of N is stored in the first
C       element of both ITAB and RTAB.  If INIT = 0, then the value of N is
C       checked against the first element of both ITAB and RTAB.  If the
C       values do not match, then the tables are declared to be invalid.
C
C       If both IDIR and INIT are nonzero, then the table generation occurs
C       prior to performing the FFT.  If both IDIR and INIT are zero, the
C       only action is the validity checking of the parameter N.
C
C       The length of the vector, N, must be factorable by 2, 3, 5 and/or 7;
C       i.e., N = 2**I * 3**J * 5**K * 7**L where I is a positive integer
C       and J, K, and L are non-negative integers.
C
C       If the value of N is invalid, then the value returned in IERR
C       is the smallest valid length that is greater than N;
C       i.e., IERR is set to the smallest value larger than N that is
C       factorable by 2, 3, 5 and/or 7.
C
C       The tables generated by this routine may not be used as input to
C       the Math Advantage routine CFFTM.
C
C       Refer to Appendix B for machine dependent notes.
C
C
C  REFERENCE
C
C       R.C. Singleton.  June 1969.  An algorithm for computing the
C       mixed-radix fast Fourier transform.  IEEE Trans. on Audio and
C       Electroacoust., Vol. AU-17, pp. 93-103.
C
C       R.C. Singleton.  1979.  Mixed-radix fast Fourier transforms.
C       Programs for Digital Signal Processing, Chapter 1.4.  IEEE Press.
C
C
C  EXAMPLE
C
C       CALL RFFTM (C, 10, 1, 1, ITAB, RTAB, IERR)
C
C       Input Operands:
C
C       C =  0.799425244E+00
C            0.448746413E+00
C            0.881257832E+00
C            0.677425504E+00
C            0.102390274E+00
C            0.601069748E+00
C            0.456132561E+00
C            0.280523002E+00
C            0.441384196E+00
C            0.238012567E+00
C
C
C       Output Operands:
C
C       C =  0.985273552E+01
C            0.869626045E+00
C            0.829594254E+00
C           -0.142352629E+01
C           -0.119456872E+00
C           -0.112421298E+01
C           -0.272630125E+00
C            0.125570774E+01
C            0.219556427E+01
C           -0.581845462E+00
C
C       ITAB = -10        RTAB = -1.00000000E+01
C                1                1.00000000E+00
C                1                8.66025388E-01
C                4               -8.09017062E-01
C                5                5.87785244E-01
C                0                3.09016973E-01
C                .                9.51056540E-01
C                .                6.23489797E-01
C                .                7.81831503E-01
C                0               -2.22520947E-01
C                3                9.74927902E-01
C                9               -9.00968909E-01
C                5                4.33883607E-01
C                7                9.51056540E-01
C                0                5.87785184E-01
C                9               -5.87785363E-01
C                3               -9.51056480E-01
C                7                1.74845553E-07
C                5                3.09016973E-01
C                0               -8.09017062E-01
C                                -8.09016943E-01
C                                 3.09017122E-01
C                                 1.00000000E+00
C                                 5.87785244E-01
C                                 9.51056540E-01
C                                 8.09017003E-01
C                                 3.09016973E-01
C                                 0.00000000E+00
C
C       IERR =  0
C
C
C  HISTORY
C     1) Jan 88          R.D. Coleman        Original
C
C---------------------------------------------------------------------
C
      SUBROUTINE RFFTM (C, N, IDIR, INIT, ITAB, RTAB, IERR)
C
C  PARAMETERS:
C
      REAL    C(*), RTAB(*)
      INTEGER N, IDIR, INIT, ITAB(*), IERR
C
C  LOCAL VARIABLES:
C
      INTEGER IC
C                      VECTOR STRIDE = 1
      INTEGER J
C                      LOOP INDEX
      INTEGER JC
C                      POINTER TO STRIDE IN ITAB
      INTEGER JCON
C                      POINTER TO START OF CONSTANT TABLE IN RTAB
      INTEGER JCOS
C                      POINTER TO START OF MAIN COSINE TABLE IN RTAB
      INTEGER JCS2
C                      POINTER TO START OF SECONDARY COSINE TABLE IN RTAB
      INTEGER JD
C                      POINTER TO DIRECTION FLAG IN RTAB
      INTEGER JDES
C                      POINTER TO START OF DESTINATION TABLE IN ITAB
      INTEGER JF
C                      POINTER TO NUMBER OF FACTORS IN ITAB
      INTEGER JFAC
C                      POINTER TO START OF FACTOR TABLE IN ITAB
      INTEGER JN
C                      POINTER TO ELEMENT COUNT IN ITAB AND RTAB
      INTEGER JP
C                      POINTER TO NUMBER OF PERMUTATIONS IN ITAB
      INTEGER JSIN
C                      POINTER TO START OF MAIN SINE TABLE IN RTAB
      INTEGER JSN2
C                      POINTER TO START OF SECONDARY SINE TABLE IN RTAB
      INTEGER JSRC
C                      POINTER TO START OF SOURCE TABLE IN ITAB
      INTEGER KDIR
C                      INTERNAL DIRECTION FLAG
      INTEGER MCON
C                      SPACE RESERVED FOR CONSTANT TABLE IN RTAB
      INTEGER MFAC
C                      SPACE RESERVED FOR FACTOR TABLE IN ITAB
      INTEGER N2
C                      N / 2
      INTEGER N4
C                      N / 4
      INTEGER NF
C                      NUMBER OF FACTORS = ELEMENT COUNT OF FACTOR TABLE
      INTEGER NP
C                      NUMBER OF PERMUTATIONS = ELEMENT COUNT OF SOURCE
C                      AND DESTINATION TABLES
C
      PARAMETER (IC = 1, JN = 1, JD = 2, JC = 2, JF = 3, JP = 4)
      PARAMETER (JCON =  3, JFAC = 5)
      PARAMETER (MCON = 11, MFAC =30)
C
C-----------------------------------------------------------------------
C
      IERR =  0
C
C  INITIALIZE TABLE POINTERS
C
      N2   = N / 2
      N4   = N / 4
      JSIN = JCON + MCON
      JCOS = JSIN + N2
      JSN2 = JCOS + N2
      JCS2 = JSN2 + N4
      JSRC = JFAC + MFAC
      JDES = JSRC + N2
C
C  SET INTERNAL DIRECTION FLAG
C
      IF      (IDIR .GE. 0) THEN
         KDIR =  1
      ELSE IF (IDIR .LT. 0) THEN
         KDIR = -1
      ENDIF
C
C  SELECT PATH
C
      IF      (INIT .NE. 0) THEN
         GO TO 100
      ELSE IF (IDIR .NE. 0) THEN
         GO TO 200
      ELSE
         CALL QTC055 (N, IERR)
         IF (IERR .EQ. N) IERR = 0
         GO TO 800
      ENDIF
C
C=======================================================================
C                           INITIALIZE TABLES
C=======================================================================
C
  100 CONTINUE
      ITAB(JN) = 0
      RTAB(JN) = 0.0
C
      CALL QTC056 (IC, N, KDIR, ITAB(JFAC), NF, RTAB(JCON),
     &             RTAB(JSIN), RTAB(JCOS), RTAB(JSN2), RTAB(JCS2),
     &             ITAB(JSRC), ITAB(JDES), NP)
C
C  CHECK IF N FACTORED OK
C
      IF (NF .EQ. 0) THEN
         CALL QTC055 (N, IERR)
         GO TO 800
      ENDIF
C
C  SAVE SOME PARAMETERS IN TABLES
C
      ITAB(JN) = -N
      ITAB(JC) =  IC
      ITAB(JF) =  NF
      ITAB(JP) =  NP
      RTAB(JN) = -FLOAT( N )
      RTAB(JD) =  FLOAT( KDIR )
C
C  WHERE NOW ?
C
      IF (IDIR .NE. 0) THEN
         GO TO 300
      ELSE
         GO TO 800
      ENDIF
C
C=======================================================================
C                        MODIFY EXISTING TABLES
C=======================================================================
C
  200 CONTINUE
C
C  CHECK VALIDITY OF TABLES
C
      IF (N .NE. -ITAB(JN) .OR. N .NE. -IFIX( RTAB(JN) )) THEN
         IERR = -2
         GO TO 800
      ENDIF
C
      NF = ITAB(JF)
      NP = ITAB(JP)
C
C  IF DIRECTION HAS CHANGED, MODIFY RTAB
C
      IF (KDIR .NE. IFIX( RTAB(JD) )) THEN
         RTAB(JD) = FLOAT( KDIR )
C
         DO 210 J = JSIN, JSIN+N2-1
            RTAB(J) = -RTAB(J)
  210    CONTINUE
C
         DO 220 J = JCS2, JCS2+N4-1
            RTAB(J) = -RTAB(J)
  220    CONTINUE
C
         DO 230 J = JCON, JCON+MCON-1, 2
            RTAB(J) = -RTAB(J)
  230    CONTINUE
      ENDIF
C
C=======================================================================
C                              PERFORM FFT
C=======================================================================
C
  300 CONTINUE
      CALL QTC057 (C, IC, N, KDIR, ITAB(JFAC), NF, RTAB(JCON),
     &             RTAB(JSIN), RTAB(JCOS), RTAB(JSN2), RTAB(JCS2),
     &             ITAB(JSRC), ITAB(JDES), NP)
C
C=======================================================================
C                               EXIT ROUTINE
C=======================================================================
C
  800 CONTINUE
      RETURN
      END
