C*****  RMFUFS  Real Full Factor and Solve          MATH ADVANTAGE REL 2.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL RMFUFS (A,NRA,N,B,NRB,M,ZTOL,IPERM,X,NRX,IERR)
C
C       where,
C
C       A       Real input/output matrix. On input, A contains the
C               matrix to be factored and solved. On output, A
C               contains the factored form.
C
C       NRA     Integer input number of rows in full matrix A.
C
C       N       Integer input order of submatrix A.
C
C       B       Real input matrix containing M right-hand sides.
C
C       NRB     Integer input number of rows in full matrix B.
C
C       M       Integer input number of right-hand sides.
C
C       ZTOL    Real input scalar, pivot zero tolerance.
C
C       IPERM   Integer output permutation vector of length N.
C
C       X       Real output matrix containing M solution vectors.
C
C       NRX     Integer input number of rows in full matrix X.
C
C       IERR    Integer output completion code:
C                   =0 if the routine terminated normally.
C                   >0 if the routine aborted because a pivot
C                      was less than or equal to ZTOL.
C                      This implies the matrix is singular.
C                      The value of IERR is the index of the column
C                      where it aborted.
C
C
C  DESCRIPTION
C
C       This routine solves the real linear system Ax=b by calling
C       RMFUFC to factor the real matrix A into LU form.   It then
C       calls RMFUSV to solve the system.
C
C
C  REFERENCE
C
C       G. W. Stewart.  1973.  Introduction to matrix computa-
C       tions.  New York: Academic Press.
C
C
C  EXAMPLE
C
C       CALL RMFUFS (A,5,5,B,5,2,ZTOL,IPERM,X,5,IERR)
C
C       Input Operands:
C
C       A = 0.000  -1.000  -5.000  11.000   8.000
C           8.000  16.000  -8.000  24.000   8.000
C          -4.000  -5.000   2.000  -4.000  -3.000
C          -3.000 -10.000   3.000 -13.000   5.000
C           2.000   6.000   6.000  -8.000  -2.000
C
C       B =  -61.00    67.00
C           -200.00   152.00
C             56.00   -39.00
C             71.00   -41.00
C              0.00   -10.00
C
C       ZTOL = 1.0E-5
C
C       Output Operands:
C
C       A = 0.125  2.000 -1.000  3.000  1.000
C          -3.000 -0.250  0.000  1.000 -2.000
C           2.000  2.000  0.125 -2.000  0.000
C           0.000 -1.000 -5.000  0.500  3.000
C          -4.000  3.000 -2.000  1.000  0.250
C
C       IPERM = 2
C               4
C               5
C               1
C               3
C
C       X =  4.000   1.000
C           -9.000   2.000
C            6.000   3.000
C            0.000   4.000
C           -5.000   5.000
C
C       IERR = 0
C
C  HISTORY
C         1) Nov 84     D. Cooper       Original.
C                       R. Coleman
C         2) Jan 88     L. Shanbeck     Expanded IERR functionality
C
      SUBROUTINE RMFUFS(A,NRA,N,B,NRB,M,ZTOL,IPERM,X,NRX,IERR)
C
      INTEGER NRA,NRB,M,N,IERR,IPERM(1),NRX
      REAL    A(1),B(1),X(1),ZTOL
C
      IERR = 0
      IF (M.LE.0 .OR. N.LE.0 .OR. NRA.LT.N .OR. NRB.LT.N .OR. NRX.LT.N)
     +   GOTO 900
      CALL RMFUFC(A,NRA,N,ZTOL,IPERM,IERR)
      IF (IERR .EQ. 0) CALL RMFUSV(A,NRA,N,B,NRB,M,IPERM,X,NRX)
900   RETURN
      END
