C*****  RMFUSV  Real Full Solver                  MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL RMFUSV (A,NRA,N,B,NRB,M,IPERM,X,NRX)
C
C       where,
C
C       A       Real input matrix.  A contains the LU factored form.
C
C       NRA     Integer input number of rows in full matrix A.
C
C       N       Integer input order of submatrix A.
C
C       B       Real input matrix containing M right-hand sides.
C
C       NRB     Integer input number of rows in full matrix B.
C
C       M       Integer input number of right-hand sides.
C
C       IPERM   Integer input permutation vector of length N.
C
C       X       Real output matrix containing M solution vectors.
C
C       NRX     Integer input number of rows in full matrix X.
C
C
C  DESCRIPTION
C
C       This routine solves a real system Ax = b,
C       where A has been factored into LU form by RMFUFC.
C
C
C  REFERENCE
C
C       G. W. Stewart.  1973.  Introduction to matrix computa-
C       tions.  New York: Academic Press.
C
C
C  EXAMPLE
C
C       CALL RMFUSV (A,5,5,B,5,2,IPERM,X,5)
C
C       Input Operands:
C
C       A = 0.125  2.000 -1.000  3.000  1.000
C          -3.000 -0.250  0.000  1.000 -2.000
C           2.000  2.000  0.125 -2.000  0.000
C           0.000 -1.000 -5.000  0.500  3.000
C          -4.000  3.000 -2.000  1.000  0.250
C
C       B =  -61.00   67.000
C           -200.00  152.000
C             56.00  -39.000
C             71.00  -41.000
C              0.00  -10.000
C
C       IPERM = 2
C               4
C               5
C               1
C               3
C
C       Output Operands:
C
C       X = 4.000  1.000
C          -9.000  2.000
C           6.000  3.000
C           0.000  4.000
C          -5.000  5.000
C
C  HISTORY
C         1) Nov 84     D. Cooper       Original.
C                       R. Coleman
C
      SUBROUTINE RMFUSV(A,NRA,N,B,NRB,M,IPERM,X,NRX)
C
      INTEGER NRA,NRB,M,N,I,IPERM(1),NRX,IA
      REAL    A(1),B(1),X(1)
C
C   *******************************************************************
C
C     DO VALIDITY CHECKS AND INITIALIZATION
C
      IF (N.LE.0  .OR. M.LE.0 .OR. NRA.LT.N .OR. NRB.LT.N .OR. NRX.LT.N)
     +  GOTO 800
C
      DO 120 I = 1, N
         CALL VMOV(B(IPERM(I)), NRB, X(I), NRX, M)
  120 CONTINUE
C
C     PERFORM FORWARD ELIMINATION
C
      CALL VSMUL(X, NRX, A(1), X, NRX, M)
      IF (N .EQ. 1) GO TO 800
C
      IA = NRA + 2
      DO 330 I = 2, N
         CALL RNDOTP(A(I),NRA,0,X,1,NRX,X(I),NRX,I-1,M,3)
         CALL VSMUL(X(I),NRX,A(IA),X(I),NRX,M)
         IA = IA + NRA + 1
  330 CONTINUE
C
C     PERFORM BACKWARD SUBSTITUTION
C
      IA = (N-1) * (NRA+1)
      DO 430 I = N-1, 1, -1
         CALL RNDOTP(A(IA),NRA,0,X(I+1),1,NRX,X(I),NRX,N-I,M,3)
         IA = IA - NRA - 1
  430 CONTINUE
C
  800 CONTINUE
      RETURN
      END
