C*****  RMMUL   Real Matrix Multiply              MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL RMMUL (A,B,C,NRC,NCC,NCA)
C
C       where,
C
C       A       Real input matrix.
C
C       B       Real input matrix.
C
C       C       Real output matrix.
C
C       NRC     Integer input number of rows in matrices C and A.
C
C       NCC     Integer input number of columns in C and B.
C
C       NCA     Integer input number of columns in A and rows in B.
C
C
C  DESCRIPTION
C
C       This routine multiplies the elements of two real
C       matrices A and B and stores the results in C.
C
C            C = A * B
C
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL RMMUL (A,B,C,2,2,3)
C
C       Input Operands:
C
C       A =   1.0        3.0     5.0
C             2.0        4.0     6.0
C
C       B =   1.0       -2.0
C            -1.0        3.0
C             2.0       -3.0
C
C       Output Operands:
C
C       C =   8.0        -8.0
C            10.0       -10.0
C
C  HISTORY
C         1) Nov 84     D. Cooper       Original.
C
      SUBROUTINE RMMUL(A,B,C,NRC,NCC,NCA)
C
      INTEGER NRC,NCC,NCA,IFLG
      REAL    A(1),B(1),C(1)
      IF (NRC.LE.0 .OR. NCC.LE.0 .OR. NCA.LE.0) GOTO 800
        IFLG = 0
        CALL RMMULG(A,NRC,B,NCA,C,NRC,NRC,NCC,NCA,IFLG)
800   RETURN
      END
