C*****  RMMULG  General Real Matrix Multiply      MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL RMMULG (A,NRA,B,NRB,C,NRC,NRCC,NCCC,NCAA,IFLG)
C
C       where,
C
C       A       Real input matrix.
C
C       NRA     Integer input number of rows in full matrix A.
C
C       B       Real input matrix.
C
C       NRB     Integer input number of rows in full matrix B.
C
C       C       Real input/output matrix.
C
C       NRC     Integer input number of rows in full matrix C.
C
C       NRCC    Integer input number of rows in submatrix C.
C
C       NCCC    Integer input number of columns in submatrix C.
C
C       NCAA    Integer input number of columns in submatrix A unless
C               A is to be transposed.  In that case, NCAA is the
C               integer input number of rows in submatrix A.
C
C       IFLG    Integer input processing option flag:
C                   Option 1 (=8) to transpose A before
C                                  multiplying.
C                   Option 2 (=4) to transpose B before
C                                  multiplying.
C                   Option 3 (= 2) to add the product of A and
C                                  B to the input values of C.
C                   Option 4 (= 1) to negate product.
C                 The value of IFLG is additive, that is:
C                   IFLG = Option 1 + Option 2 + Option 3 +
C                          Option 4
C                 For example, if IFLG = 11, (i.e., 8+2+1) RMMULG
C                 will transpose A before multiplying, negate the
C                 product of A and B, and add the result to C.
C
C
C  DESCRIPTION
C
C       This routine multiplies the elements of two real
C       matrices, A and B, and stores the results in matrix C.  This
C       routine is identical to RMMULS except for the addition of
C       parameter IFLG which gives the routine greater flexibility.
C
C       The input matrices A and B are not altered.
C
C            If IFLG = 0, C = A * B
C
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL RMMULG (A,2,B,3,C,2,2,2,3,0)
C
C       Input Operands:
C
C       A = 1.0    3.0    5.0
C           2.0    4.0    6.0
C
C       B = 1.0   -2.0
C          -1.0    3.0
C           2.0   -3.0
C
C       Output Operands:
C
C       C =  8.0     -8.0
C           10.0    -10.0
C
C  HISTORY
C         1) Apr 85     D. Cooper       Original.
C
      SUBROUTINE RMMULG(A,NRA,B,NRB,C,NRC,NRCC,NCCC,NCAA,IFLG)
C
      INTEGER NRA,NRB,NRC,NRCC,NCCC,NCAA,IFLG,I,JB,JC,TRAA,TRAB,JSW
      REAL    A(1),B(1),C(1)
      IF (NRCC.LE.0 .OR. NCCC.LE.0 .OR. NCAA.LE.0 .OR.
     +    NRA.LE.0 .OR. NRB.LE.0 .OR. NRC.LT.NRCC .OR.
     +    IFLG.LT.0 .OR. IFLG.GE.16) GOTO 800
C
C     THE INPUT SWITCH IFLG IS USED AS FOLLOWS:
C     BIT 0 SETS NEGATE, BIT 1 SETS ACCUMULATE (PASSED TO RNDOTP)
C     BIT 2 SETS TRANSPOSE B BEFORE MULTIPLY,
C     BIT 3 SETS TRANSPOSE A BEFORE MULTIPLY.
C
      TRAA = 0
      TRAB = 0
      JSW = IFLG
C      IF (JSW.GE.16) JSW = MOD(JSW,16)
      IF (JSW.LT.8) GOTO 10
        JSW = JSW - 8
        TRAA = 1
10    CONTINUE
      IF (JSW.LT.4) GOTO 20
        JSW = JSW - 4
        TRAB = 1
20    CONTINUE
C
      JB = 1
      JC = 1
      IF (TRAA .EQ. 1 .OR. TRAB .EQ. 1) GOTO 400
C
C     ROWS OF A DOTTED WITH COLUMNS OF B:
      IF(NRA.LT.NRCC .OR. NRB.LT.NCAA) GOTO 800
      DO 200 I = 1, NCCC
        CALL RNDOTP(A,NRA,1,B(JB),1,0,C(JC),1,NCAA,NRCC,JSW)
        JB  = JB + NRB
        JC  = JC + NRC
200   CONTINUE
      GOTO 800
C
C
400   CONTINUE
C     TRANSPOSE AT LEAST ONE MATRIX BEFORE MULTIPLYING:
      IF (TRAA .EQ. 1 .AND. TRAB .EQ. 1) GOTO 700
      IF (TRAB .EQ. 1) GOTO 600
C
C     TRANSPOSE A ONLY:
C     COLUMNS OF A DOTTED WITH COLUMNS OF B:
      IF(NRA.LT.NCAA .OR. NRB.LT.NCAA) GOTO 800
      DO 410 I = 1,NCCC
        CALL RNDOTP(A,1,NRA,B(JB),1,0,C(JC),1,NCAA,NRCC,JSW)
        JB = JB + NRB
        JC = JC + NRC
410   CONTINUE
      GOTO 800
C
600   CONTINUE
C     TRANSPOSE B ONLY:
C     ROWS OF A DOTTED WITH ROWS OF B:
      IF(NRA.LT.NRCC .OR. NRB.LT.NCCC) GOTO 800
      DO 510 I = 1,NCCC
        CALL RNDOTP(A,NRA,1,B(I),NRB,0,C(JC),1,NCAA,NRCC,JSW)
        JC = JC + NRC
510   CONTINUE
      GOTO 800
C
700   CONTINUE
C     TRANSPOSE A AND B:
C     COLUMNS OF A DOTTED WITH ROWS OF B:
      IF(NRA.LT.NCAA .OR. NRB.LT.NCCC) GOTO 800
      DO 710 I = 1,NCCC
        CALL RNDOTP(A,1,NRA,B(I),NRB,0,C(JC),1,NCAA,NRCC,JSW)
        JC = JC + NRC
710   CONTINUE
C
800   RETURN
      END
