C*****  RMSUFL  Real Matrix Unsymmetric Fill-in      MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C
C       CALL RMSUFL (S,IRN,ICP,IDP,N,NS,M,VWK,LWK,T,JRN,JCP,JDP,NT,IERR)
C
C       where,
C
C       S       Real input vector of length NS.
C               Contains the elements of the real matrix
C               A stored in sparse symmetric format.
C
C       IRN     Integer input vector of length NS containing the
C               row number of each element stored in vector S.
C
C       ICP     Integer input vector of column pointers of length N+1.
C
C       IDP     Integer input vector of diagonal pointers of length N.
C
C       N       Integer input order of matrix A.
C
C       NS      Integer input element count of vector S.
C
C       M       Integer input maximum length of T and JRN.
C
C       VWK     Real workspace vector of length N.
C
C       LWK     Integer workspace vector of length N.
C
C       T       Real output vector of length NT.
C               Contains updated S  with space for fill-in
C               provided in the appropriate positions.
C
C       JRN     Integer output vector of length NT containing
C               the row number of each element stored in vector T.
C
C       JCP     Integer output vector of column pointers of length N+1.
C
C       JDP     Integer output vector of diagonal pointers of length N.
C
C       NT      Integer output element count of vector T.
C
C       IERR    Integer output completion code:
C                   =0 if the routine terminated normally.
C                   =1 if the routine aborted because the
C                      specified value for M was too small to
C                      accommodate all fill-in values.
C
C
C  DESCRIPTION
C
C       This routine builds the sparse unsymmetric format
C       vectors T, JRN, JCP, and JDP (with space reserved for
C       fill-in) describing matrix A.  The non-zero elements of
C       matrix A are input by vectors S, IRN, ICP, and IDP.  The
C       output vectors are in a form usable by RMSUFC and RMSUFS.
C
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL RMSUFL(S,IRN,ICP,IDP,10,17,18,VWK,LWK,T,JRN,JCP,JDP,NT,
C      +            IERR)
C
C       Input Operands:
C
C       S = 2.000      IRN =  1  ICP =  1  IDP =  1
C          16.000             2         2         2
C           2.000             5         6         6
C           3.000             6         8         8
C           3.000            10        10        10
C           2.000             3        11        11
C          -1.000             4        12        13
C           4.000             4        14        14
C           4.000             8        15        15
C           2.000             5        16        17
C           6.000             6        18
C           2.000             4
C           4.000             7
C          10.000             8
C           2.000             9
C           1.000             8
C           8.000            10
C
C       Output Operands:
C
C       T = 2.000      JRN =  1  JCP =  1  JDP =  1   NT =  18
C          16.000             2         2         2
C           2.000             5         6         6
C           3.000             6         8         8
C           3.000            10        10        10
C           2.000             3        11        11
C          -1.000             4        12        13
C           4.000             4        15        15
C           4.000             8        16        16
C           2.000             5        17        18
C           6.000             6        19
C           2.000             4
C           4.000             7
C           0.000 (Fill-in)   8
C          10.000             8
C           2.000             9
C           1.000             8
C           8.000            10
C
C       IERR = 0
C
C  HISTORY
C         1) May 85     D. Cooper       Original.
C                       R. Coleman
C         2) Aug 85     D. Cooper       ECR 8/6/85--enhanced robustness
C                                       towards invalid IRN,ICP,IDP.
C
      SUBROUTINE RMSUFL(S,IRN,ICP,IDP,N,NS,M,VWK,LWK,T,JRN,JCP,JDP,NT,
     +  IERR)
C
      REAL    S(1), T(1), VWK(1)
      INTEGER N,NS,IRN(1),ICP(1),IDP(1),JRN(1),JCP(1),JDP(1),NT,IERR,M
      INTEGER LWK(1),FALSE,TRUE
      INTEGER I,J,K,K1,K2
      DATA    FALSE, TRUE /0,1/
C
      IERR = 0
      NT = 0
      IF (N.LE.0 .OR. NS.LE.0 .OR. M.LT.NS) GOTO 9000
C
C ... INITIALIZE WORKSPACES ***
C
      DO 110 I = 1, N
         JDP(I) = 0
         VWK(I)   = 0.0
         LWK(I) = FALSE
 110  CONTINUE
C
C ... DO FIRST COLUMN ***
C
      IF (IRN(1).EQ.1) GOTO 115
        T(1) = 0.0
        JRN(1) = 1
        NT = 1
115   CONTINUE
      JCP(1) = 1
      JDP(1) = 1
      K1 = ICP(1)
      K2 = ICP(2)-1
      IF (K1.GT.K2) GOTO 125
        IF ((K2-K1+NT).LT.M) GOTO 117
          IERR = 1
          GOTO 9000
117     CONTINUE
        DO 120 K = K1,K2
          NT = NT + 1
          T(NT) = S(K)
          JRN(NT) = IRN(K)
120     CONTINUE
125   CONTINUE
C
C ... START MAIN LOOP ***
C
      IF (N.LT.2) GOTO 900
      DO 180 J = 2, N
         JCP(J) = NT + 1
         K1 = ICP(J)
         K2 = ICP(J+1) - 1
         IF (K1 .GT. K2) GOTO 131
           DO 130 K = K1, K2
             I = IRN(K)
             VWK(I) = S(K)
             LWK(I) = TRUE
 130       CONTINUE
 131     CONTINUE
C
C ... DO FILL-IN ***
C
         DO 150 I = 1, J-1
            IF(LWK(I) .EQ. FALSE) GO TO 150
            K1 = JDP(I) + 1
            K2 = JCP(I+1) - 1
            IF(K1 .GT. K2) GO TO 150
            DO 140 K = K1, K2
               LWK(JRN(K)) = TRUE
 140        CONTINUE
 150     CONTINUE
C
C ... COMPRESS COLUMN J INTO T ***
C
         DO 170 I = 1, N
            IF (LWK(I) .EQ. FALSE) GO TO 170
            NT = NT + 1
            IF (NT.LE.M) GOTO 160
              IERR = 1
              NT = NT - 1
              GOTO 9000
160         CONTINUE
            T(NT) = VWK(I)
            JRN(NT) = I
            IF (I .EQ. J) JDP(J) = NT
            VWK(I) = 0.0
            LWK(I) = FALSE
 170     CONTINUE
 180  CONTINUE
C
900   JCP(N+1) = NT+1
9000  RETURN
      END
