C*****  RMTRAN  Real Matrix Transpose             MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL RMTRAN (A,NRA,C,NRC,NRAA,NCAA)
C
C       where,
C
C       A       Real input matrix.
C
C       NRA     Integer input number of rows in full matrix A.
C
C       C       Real output matrix.
C
C       NRC     Integer input number of rows in full matrix B.
C
C       NRAA    Integer input number of rows in submatrix A.
C
C       NCAA    Integer input number of columns in submatrix A.
C
C
C  DESCRIPTION
C
C       This routine transposes the elements of a real matrix A
C       and stores the results in C.
C
C       A and C must not overlay each other.
C
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL RMTRAN (A,3,C,4,3,4)
C
C       Input Operands:
C
C       A =  1.0        4.0     7.0     10.0
C            2.0        5.0     8.0     11.0
C            3.0        6.0     9.0     12.0
C
C       Output Operands:
C
C       C =   1.0        2.0         3.0
C             4.0        5.0         6.0
C             7.0        8.0         9.0
C            10.0       11.0        12.0
C
C  HISTORY
C         1) Nov 84     D. Cooper       Original.
C
      SUBROUTINE RMTRAN(A,NRA,B,NRB,NRAA,NCAA)
C
      INTEGER NRA,NRB,NRAA,NCAA,COL,ROW,IA,IB
      REAL A(1),B(1)
      IF (NRAA.LE.0 .OR. NCAA.LE.0 .OR.
     +  NRA.LT.NRAA .OR. NRB.LT.NCAA) GO TO 32
      DO 30 COL = 1,NCAA
        IB = COL
        IA = 1 + (COL-1)*NRA
        DO 20 ROW = 1,NRAA
          B(IB) = A(IA)
          IA = IA + 1
          IB = IB + NRB
20      CONTINUE
30    CONTINUE
32    RETURN
      END
