C*****  RSEAA  Real Symmetric Eigenvalues & Eigenvectors    MATH ADV REL 3.0
C
C    ** COPYRIGHT 1986 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL RSEAA(NM,N,A,W,Z,WRK,IERR)
C
C       where,
C
C       NM      Integer input number of rows in full matrices A and Z.
C
C       N       Integer input order of matrices A and Z.
C
C       A       Real input matrix.
C
C       W       Real output vector of length N, eigenvalues.
C
C       Z       Real output matrix, eigenvectors.
C
C       WRK     Real workspace vector of length 2*N.
C
C       IERR    Integer output completion code:
C                If IERR=0, the routine terminated normally.
C                If 1<=IERR<=N, the calculation of eigenvalue IERR
C                 failed to converge.  Eigenvalues 1 to IERR-1 are still
C                 valid; none of the eigenvectors are valid.
C
C  DESCRIPTION
C
C       This routine determines all eigenvalues and all eigenvectors
C       of real symmetric matrix A.
C
C       The eigenvectors are orthonormal.
C
C       On input, only the full lower triangle of matrix A need be
C       defined.  On output, the strict lower triangle of matrix A is
C       altered; the full upper triangle is unchanged.
C
C       This routine contains a subset of the EISPACK eigensystem
C       package developed by Argonne National Laboratory.  It uses the
C       EISPACK recommended path of TRED2-TQL2.
C
C  REFERENCE
C
C       G. W. Stewart.  1973.  Introduction to matrix computa-
C       tions.  New York: Academic Press.
C
C
C  EXAMPLE
C
C       CALL RSEAA(3,3,A,W,Z,WRK,IERR)
C
C       Input Operands:
C
C       A =  6.0  4.0  1.0
C            4.0  4.0 11.0
C            1.0 11.0  1.0
C
C       Output Operands:
C
C       W = 15.106
C            4.743
C           -8.849
C
C       Z =  0.529   1.000   0.178
C            1.000  -0.220  -0.912
C            0.817  -0.378   1.000
C
C       IERR = 0
C
C       Note concerning output values:
C
C       The eigenvalues (array W) may be arranged in any order; and the
C       rows of the eigenvectors (matrix Z) are associated with a particular
C       eigenvalue and will be ordered correspondingly.  Also, the eigen-
C       vectors may be multiplied by a constant and still be correct
C       (i.e., orthonormal vectors).
C
C  HISTORY
C         1) Sep 86     L. Tarvestad    Original.
C
      SUBROUTINE RSEAA(NM,N,A,W,Z,WRK,IERR)
      INTEGER N,NM,IERR
      REAL A(1),W(1),Z(1),WRK(1)
C
      IF (N.LE.0 .OR. N.GT.NM) GO TO 50
      CALL  QTC044(NM,N,A,W,WRK,Z)
      CALL  QTC042(NM,N,W,WRK,Z,IERR)
50    RETURN
      END
