C*****  SCASUM    Sum of Magnitudes of Real and Imag Parts    MATH ADV REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       SW = SCASUM (N,CX,INCX)
C
C       where,
C
C       N       Integer input element count.
C
C       CX      Complex input vector.
C
C       INCX    Integer input stride for vector CX.
C               May not be negative.
C
C
C  DESCRIPTION
C
C       This function returns the sum of the absolute values of the
C       real and imaginary parts of the elements of complex vector CX.
C
C       SCASUM = sum (ABS(REAL(CX(i))) + ABS(IMAG(CX(i))))   for i=1,N
C
C  REFERENCE
C
C       J.J. Dongarra and C.B. Moler, J.R. Bunch, G.W. Stewart.  1979.
C       LINPACK Users' Guide.  Appendix A: Basic Linear Algebra Subprograms.
C       SIAM
C
C
C  EXAMPLE
C
C       SW = SCASUM (5,CX,1)
C
C       Input Operands:
C
C       CX = ( 1.000, 5.000)
C            ( 2.000, 4.000)
C            (-3.000, 3.000)
C            ( 4.000, 2.000)
C            ( 5.000,-1.000)
C
C       Output Result:
C
C       SW = 30.0
C
C  HISTORY
C         1) Jan 88     L. Shanbeck     Original.
C
C
      REAL FUNCTION SCASUM(N,CX,INCX)
      COMPLEX CX(1)
      INTEGER N,INCX,I,NS
C
      SCASUM = 0.0
      IF(N.LE.0 .OR. INCX.LT.0) GO TO 999
C
      NS = N*INCX
      DO 10 I = 1,NS,INCX
        SCASUM = SCASUM + ABS(REAL(CX(I))) + ABS(AIMAG(CX(I)))
   10 CONTINUE
999   RETURN
      END
