C*****  SPLBAP  Bicubic Spline Approximation     MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL SPLBAP(A,IA,B,IB,C,WRK,WRK1,D,M,N)
C
C       where,
C
C       A       Real input vector of length M containing tabulated
C               independent variables.
C
C       IA      Integer input stride for vector A.
C
C       B       Real input vector of length N containing tabulated
C               independent variables.
C
C       IB      Integer input stride for vector B.
C
C       C       Real input matrix of size M by N containing the results
C               of a function evaluated for the variables specified in
C               vectors A and B.  eg. C(i,j) = Fx(A(i),B(j))
C
C       WRK     Real workspace vector of length N.
C
C       WRK1    Real workspace vector of length N.
C
C       D       Real output matrix containing the second-derivatives
C               of one-dimensional natural cubic splines of the rows
C               of array C. This matrix is of size M by N.
C
C       M       Integer input element count for vector A.
C
C       N       Integer input element count for vector B.
C
C
C  DESCRIPTION
C
C      This routine computes one-dimensional natural cubic splines
C      of the rows of matrix C and returns the second-derivatives
C      in matrix D.
C
C      Matrix D may be used as input to the routine SPLBIN, bicubic
C      spline interpolation, to compute a two-dimensional interpolated
C      point on a surface defined by the same function.  For a
C      particular function, any number of calls to SPLBIN can be made
C      after one call to SPLBAP.
C
C
C  REFERENCES
C
C       J.H. Ahlberg, E.N. Nilson and J.L. Walsh. 1976. The Theory
C       of Splines and Their Applications. New York: Acedemic Press.
C
C       T.N.E. Greville. 1969. Introduction To Spline Functions. In
C       Theory and Applications of Spline Functions. New York: Acedemic
C       Press.
C
C
C  EXAMPLE
C                                2    2
C       Using function C(A,B) = A + B
C
C       CALL SPLBAP(A,1,B,1,C,WRK,WRK1,D,10,10)
C
C       Input Operands:
C
C       A = 0.00
C           1.00
C           2.00
C           3.00
C           4.00
C           5.00
C           6.00
C           7.00
C           8.00
C           9.00
C
C       B = 0.00
C           1.00
C           2.00
C           3.00
C           4.00
C           5.00
C           6.00
C           7.00
C           8.00
C           9.00
C
C       C = 0.    1.    4.    9.    16.   25.   36.   49.   64.   81.
C           1.    2.    5.    10.   17.   26.   37.   50.   65.   82.
C           4.    5.    8.    13.   20.   29.   40.   53.   68.   85.
C           9.    10.   13.   18.   25.   34.   45.   58.   73.   90.
C           16.   17.   20.   25.   32.   41.   52.   65.   80.   97.
C           25.   26.   29.   34.   41.   50.   61.   74.   89.   106.
C           36.   37.   40.   45.   52.   61.   72.   85.   100.  117.
C           49.   50.   53.   58.   65.   74.   85.   98.   113.  130.
C           64.   65.   68.   73.   80.   89.   100.  113.  128.  145.
C           81.   82.   85.   90.   97.   106.  117.  130.  145.  162.
C
C       Output Operands:
C
C       D = 0.0 2.534 1.857 2.038 1.992 1.992 2.038 1.857 2.536 0.0
C           0.0 2.534 1.857 2.038 1.992 1.992 2.038 1.857 2.536 0.0
C           0.0 2.534 1.857 2.038 1.992 1.992 2.038 1.857 2.536 0.0
C           0.0 2.534 1.857 2.038 1.992 1.992 2.038 1.857 2.536 0.0
C           0.0 2.534 1.857 2.038 1.992 1.992 2.038 1.857 2.536 0.0
C           0.0 2.534 1.857 2.038 1.992 1.992 2.038 1.857 2.536 0.0
C           0.0 2.534 1.857 2.038 1.992 1.992 2.038 1.857 2.536 0.0
C           0.0 2.534 1.857 2.038 1.992 1.992 2.038 1.857 2.536 0.0
C           0.0 2.534 1.857 2.038 1.992 1.992 2.038 1.857 2.536 0.0
C           0.0 2.534 1.857 2.038 1.992 1.992 2.038 1.857 2.536 0.0
C
C
C  HISTORY
C         1) Dec 87       C. Ward         Original.
C
      SUBROUTINE SPLBAP(A,IA,B,IB,C,WRK,WRK1,D,M,N)
C
      INTEGER IA,IB,J,K,M,N
      REAL A(1),B(1),WRK(1),WRK1(1),C(M,N),D(M,N)
      REAL EPS,TINY,HUGE
      DATA EPS,TINY,HUGE/0.0,0.0,0.0/
      IF ( N.LE.0 ) GO TO 999
C
C     SET MACHINE DEPENDENT VARIABLES
C
      IF (HUGE.EQ.0.0) THEN
         CALL QTC045(EPS,TINY,HUGE)
      ENDIF
      DO 13 J=1,M
         CALL SPLCAP(B,IB,C(J,1),M,HUGE,HUGE,WRK,WRK1,1,N)
         DO 12 K=1,N
            D(J,K) = WRK1(K)
 12      CONTINUE
 13   CONTINUE
C
  999 CONTINUE
      RETURN
      END
