C*****  SPLCAP  Cubic Spline Approximation       MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL SPLCAP (A,IA,B,IB,YP1,YPN,WRK,C,IC,N)
C
C       where,
C
C       A       Real input vector.
C
C       IA      Integer input stride for vector A.
C
C       B       Real input vector.
C
C       IB      Integer input stride for vector B.
C
C       YP1     Real input scalar representing the first derivative
C               of interpolating function at first point.
C
C       YPN     Real input scalar representing the first derivative
C               of interpolating function at last point.
C
C       WRK     Real workspace vector of length N.
C
C       C       Real output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count for vectors A, B and C.
C
C
C  DESCRIPTION
C
C       This routine approximates a function given arrays A and B and
C       the first derivatives of the interpolating function at the
C       tabulated points 1 and N, denoted by YP1 and YPN respectively.
C       The routine outputs a table of second derivatives of the
C       interpolating function, denoted by array C, corresponding to the
C       points 1 through N in arrays A and B.  Once this table is
C       computed the routine SPLCIN can be called to obtain values
C       of the interpolated function corresponding to any value
C       between A(1) and A(N).
C
C
C  REFERENCES
C
C       J.H. Ahlberg, E.N. Nilson and J.L. Walsh. 1976. The Theory
C       of Splines and Their Applications. New York: Acedemic Press.
C
C       T.N.E. Greville. 1969. Introduction To Spline Functions. In
C       Theory and Applications of Spline Functions. New York: Acedemic
C       Press.
C
C
C  EXAMPLE
C                         2
C       Using function B=A + A + 1
C
C       CALL SPLCAP (A,1,B,1,YP1,YPN,WRK,C,1,10)
C
C       Input Operands:
C
C       A = 0.00
C           1.00
C           2.00
C           3.00
C           4.00
C           5.00
C           6.00
C           7.00
C           8.00
C           9.00
C
C       B = 1.00
C           3.00
C           7.00
C           13.00
C           21.00
C           31.00
C           43.00
C           57.00
C           73.00
C           91.00
C
C       YP1 = 1.0
C
C       YPN = 19.0
C
C       Output Operands:
C
C       C = 2.00
C           2.00
C           2.00
C           2.00
C           2.00
C           2.00
C           2.00
C           2.00
C           2.00
C           2.00
C
C  HISTORY
C         1) Nov 87       C. Ward         Original.
C
      SUBROUTINE SPLCAP(A,IA,B,IB,YP1,YPN,WRK,C,IC,N)
C
      INTEGER I,II,IA,IB,IC,JJ,K,KK,N
      REAL A(1),B(1),C(1),WRK(1),YP1,YPN,P,QN,SIG,UN
      REAL EPS,TINY,HUGE
      DATA EPS,TINY,HUGE/0.0,0.0,0.0/
      IF ( N.LE.0 ) GO TO 999
C
C     SET MACHINE DEPENDENT VARIABLES
C
      IF (HUGE .EQ. 0.0) THEN
         CALL QTC045(EPS,TINY,HUGE)
      ENDIF
C
      IF (YP1.GE.HUGE) THEN
        C(1)=0.0
        WRK(1)=0.0
      ELSE
        C(1)=-0.5
        WRK(1)=(3.0/(A(1+IA)-A(1)))*((B(1+IB)-B(1))/
     +         (A(1+IA)-A(1))-YP1)
      ENDIF
C
      II=1+IA
      JJ=1+IB
      KK=1+IC
C
      DO 11 I=2,N-1
        SIG=(A(II)-A(II-IA))/(A(II+IA)-A(II-IA))
        P=SIG*C(KK-IC)+2.0
        C(KK)=(SIG-1.)/P
        WRK(I)=(6.0*((B(JJ+IB)-B(JJ))/(A(II+IA)-A(II))-
     +         (B(JJ)-B(JJ-IB))/(A(II)-A(II-IA)))
     +         /(A(II+IA)-A(II-IA))-SIG*WRK(I-1))/P
        II=II+IA
        JJ=JJ+IB
        KK=KK+IC
11    CONTINUE
      IF (YPN.GE.HUGE) THEN
        QN=0.0
        UN=0.0
      ELSE
        QN=0.5
        UN=(3.0/(A(II)-A(II-IA)))*(YPN-(B(JJ)-B(JJ-IB))
     +      /(A(II)-A(II-IA)))
      ENDIF
      C(KK)=(UN-QN*WRK(N-1))/(QN*C(KK-IC)+1.0)
      DO 12 K=N-1,1,-1
        KK=KK-IC
        C(KK)=C(KK)*C(KK+IC)+WRK(K)
12    CONTINUE
  999 CONTINUE
      RETURN
      END
