C*****  SPLCIN  Cubic Spline Interpolation       MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL SPLCIN (A,IA,B,IB,C,IC,D,E,N)
C
C       where,
C
C       A       Real input vector of length N.
C
C       IA      Integer input stride for vector A.
C
C       B       Real input vector of length N.
C
C       IB      Integer input stride for vector B.
C
C       C       Real input vector which is the second derivative
C               at points (A(i),B(i)), calculated in SPLCAP.
C
C       IC      Integer input stride for vector C.
C
C       D       Real input scalar representing point in function at
C               which to find interpolated value.
C
C       E       Real output scalar representing interpolated value at
C               point D.
C
C       N       Integer input element count for vectors A, B and C.
C
C
C  DESCRIPTION
C
C       This routine calculates an interpolated value of a function.
C       The function values are defined at points A(i); the value of
C       the function at each point A(i) is given in B(i). The
C       interpolated value at the point D is calculated by a cubic
C       spline technique, using a table of second derivatives in
C       vector C (this table is calculated by SPLCAP).  The values of
C       the elements in array A are assumed to be monotonically
C       increasing and the value of D must satisfy the relationship:
C          A(1) <= D <= A(N).
C
C       If A(I) <= D <= A(I+1), and
C          H = A(I+1) - A(I)
C          A1 = (A(I+1)-D)/H
C          B1 = (D-A(I))/H
C       then
C          E = A1*B(I)+B1*B(I+1)+
C                ((A1**3-A1)*C(I)+(B1**3-B1)*C(I+1))*(H**2)/6
C
C
C  REFERENCES
C
C       J.H. Ahlberg, E.N. Nilson and J.L. Walsh. 1976. The Theory
C       of Splines and Their Applications. New York: Acedemic Press.
C
C       T.N.E. Greville. 1969. Introduction To Spline Functions. In
C       Theory and Applications of Spline Functions. New York: Acedemic
C       Press.
C
C
C  EXAMPLE
C                         2
C       Using function B=A + A + 1
C
C       CALL SPLCIN (A,1,B,1,C,1,D,E,10)
C
C       Input Operands:
C
C       A = 0.00
C           1.00
C           2.00
C           3.00
C           4.00
C           5.00
C           6.00
C           7.00
C           8.00
C           9.00
C
C       B = 1.00
C           3.00
C           7.00
C           13.00
C           21.00
C           31.00
C           43.00
C           57.00
C           73.00
C           91.00
C
C       C = 2.00
C           2.00
C           2.00
C           2.00
C           2.00
C           2.00
C           2.00
C           2.00
C           2.00
C           2.00
C
C       D = 3.5
C
C       Output Operands:
C
C       E = 16.75
C
C  HISTORY
C         1) Dec 87     C. Ward           Original.
C
      SUBROUTINE SPLCIN(A,IA,B,IB,C,IC,D,E,N)
C
      INTEGER IA,IB,IC,K,KHI,KHIB,KHIC,KLO,KLOB,KLOC,N,KCHECK
      REAL A(1),B(1),C(1),D,E,A1,B1,H
      IF ( N.LE.0 ) GO TO 999
C
      KLO = 1
      KHI = 1+(N-1)*IA
 1    IF (KHI-KLO.GT.IA) THEN
         K = (KHI+KLO)/2
         KCHECK=MOD((K-1),IA)
         IF (KCHECK.NE.0) K=K-KCHECK
         IF (A(K).GT.D) THEN
            KHI = K
         ELSE
            KLO = K
         ENDIF
      GOTO 1
      ENDIF
C
      H = A(KHI)-A(KLO)
      IF (H.EQ.0.0) GOTO 999
C
      A1 = (A(KHI)-D)/H
      B1 = (D-A(KLO))/H
      KLOB = (KLO*IB-IB)/IA + 1
      KHIB = (KHI*IB-IB)/IA + 1
      KLOC = (KLO*IC-IC)/IA + 1
      KHIC = (KHI*IC-IC)/IA + 1
      E = A1*B(KLOB)+B1*B(KHIB)+
     +    ((A1**3-A1)*C(KLOC)+(B1**3-B1)*C(KHIC))*(H**2)/6.0
  999 CONTINUE
      RETURN
      END
