C*****  SROTM    Apply Modified Givens Plane Rotation  MATH ADV REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL SROTM (N,SX,INCX,SY,INCY,SPARAM)
C
C       where,
C
C       N       Integer input element count for vectors SX and SY.
C
C       SX      Real input/output vector of length N.
C
C       INCX    Integer input stride for vector SX.
C
C       SY      Real input/output vector of length N.
C
C       INCY    Integer input stride for vector SY.
C
C       S       Real input vector of length 5.
C               S(1) = Flag indicating 2 by 2 matrix format as below.
C               S(2) = value of 2 by 2 matrix element (1,1)
C               S(3) = value of 2 by 2 matrix element (2,1)
C               S(4) = value of 2 by 2 matrix element (1,2)
C               S(5) = value of 2 by 2 matrix element (2,2)
C
C  DESCRIPTION
C
C       This routine computes a modified Givens transformation of the form
C
C              |SX(i)|      |S(2)  S(4)|   |SX(i)|
C              |SY(i)|  =   |S(3)  S(5)|   |SY(i)|    for i=1,N
C
C       where the 2 by 2 matrix is constructed from the values of S
C       depending on the following flag value:
C         S(1)=-1.0        S(1)=0.0        S(1)=1.0      S(1)=-2.0
C       |S(2)  S(4)|     |1.0  S(4)|     |S(2)  1.0|     |1.0  0.0|
C       |S(3)  S(5)|     |S(3)  1.0|     |-1.0 S(5)|     |0.0  1.0|
C
C       If N<=0 or if S(1)=-2.0 then the routine returns immediately.
C
C
C  REFERENCE
C
C       C.L. Lawson and R.J. Hanson, D.R. Kincaid, F.T. Krogh.
C       September, 1979.  Basic Linear Algebra Subprograms for Fortran Usage.
C       ACM Trans. Math. Software, Vol 5, Number 3
C
C  EXAMPLE
C
C       CALL SROTM (5,SX,1,SY,1,S)
C
C       Input Operands:
C
C       SX =  1.000
C             2.000
C             3.000
C             4.000
C             5.000
C
C       SY = -2.000
C            -1.000
C             0.000
C             1.000
C             2.000
C
C       S  =  0.000
C             0.000
C             3.000
C             2.000
C             0.000
C
C       Output Operands:
C
C       SX = -3.000
C             0.000
C             3.000
C             6.000
C             9.000
C
C       SY =  1.000
C             5.000
C             9.000
C            13.000
C            17.000
C
C  HISTORY
C         1) Jan 88     L. Shanbeck     Original.
C
C
      SUBROUTINE SROTM (N,SX,INCX,SY,INCY,S)
C
      REAL SX(1),SY(1),S(5),STEMP
      INTEGER N,INCX,INCY,IX,IY,I
C
      IF (N.LE.0 .OR. S(1).EQ.-2.0) GO TO 999
C
      IX = 1
      IY = 1
      IF (INCX.LT.0) IX = (1-N)*INCX + 1
      IF (INCY.LT.0) IY = (1-N)*INCY + 1
C
      IF (S(1)) 120,20,220
C
C        S(1)=0.0, DIAGONAL ELEMENTS = 1.0
   20 S12 = S(4)
      S21 = S(3)
      DO 30 I = 1,N
        STEMP  = SX(IX) + S12*SY(IY)
        SY(IY) = S21*SX(IY) + SY(IX)
        SX(IX) = STEMP
        IX = IX + INCX
        IY = IY + INCY
   30 CONTINUE
      GO TO 999
C
C        S(1)=-1.0, USE ALL S VALUES
  120 S11 = S(2)
      S12 = S(4)
      S21 = S(3)
      S22 = S(5)
      DO 130 I = 1,N
        STEMP  = S11*SX(IX) + S12*SY(IY)
        SY(IY) = S21*SX(IY) + S22*SY(IX)
        SX(IX) = STEMP
        IX = IX + INCX
        IY = IY + INCY
  130 CONTINUE
      GO TO 999
C
C        S(1)=1.0
  220 S11 = S(2)
      S22 = S(5)
      DO 230 I = 1,N
        STEMP  = S11*SX(IX) + SY(IY)
        SY(IY) = S22*SY(IY) - SX(IX)
        SX(IX) = STEMP
        IX = IX + INCX
        IY = IY + INCY
  230 CONTINUE
  999 RETURN
      END
